/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.oteltrace;

import com.linecorp.armeria.server.Server;
import io.grpc.BindableService;
import io.grpc.MethodDescriptor;
import io.opentelemetry.proto.collector.trace.v1.TraceServiceGrpc;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import org.opensearch.dataprepper.armeria.authentication.GrpcAuthenticationProvider;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.codec.ByteDecoder;
import org.opensearch.dataprepper.model.configuration.PipelineDescription;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.plugin.PluginFactory;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.source.Source;
import org.opensearch.dataprepper.plugins.certificate.CertificateProvider;
import org.opensearch.dataprepper.plugins.otel.codec.OTelOutputFormat;
import org.opensearch.dataprepper.plugins.otel.codec.OTelProtoCodec;
import org.opensearch.dataprepper.plugins.otel.codec.OTelProtoOpensearchCodec;
import org.opensearch.dataprepper.plugins.otel.codec.OTelProtoStandardCodec;
import org.opensearch.dataprepper.plugins.otel.codec.OTelTraceDecoder;
import org.opensearch.dataprepper.plugins.server.CreateServer;
import org.opensearch.dataprepper.plugins.server.ServerConfiguration;
import org.opensearch.dataprepper.plugins.source.oteltrace.ConvertConfiguration;
import org.opensearch.dataprepper.plugins.source.oteltrace.OTelTraceGrpcService;
import org.opensearch.dataprepper.plugins.source.oteltrace.OTelTraceSourceConfig;
import org.opensearch.dataprepper.plugins.source.oteltrace.certificate.CertificateProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="otel_trace_source", pluginType=Source.class, pluginConfigurationType=OTelTraceSourceConfig.class)
public class OTelTraceSource
implements Source<Record<Object>> {
    private static final String PLUGIN_NAME = "otel_trace_source";
    private static final Logger LOG = LoggerFactory.getLogger(OTelTraceSource.class);
    static final String SERVER_CONNECTIONS = "serverConnections";
    private final OTelTraceSourceConfig oTelTraceSourceConfig;
    private final PluginMetrics pluginMetrics;
    private final GrpcAuthenticationProvider authenticationProvider;
    private final CertificateProviderFactory certificateProviderFactory;
    private final String pipelineName;
    private Server server;
    private final ByteDecoder byteDecoder;

    @DataPrepperPluginConstructor
    public OTelTraceSource(OTelTraceSourceConfig oTelTraceSourceConfig, PluginMetrics pluginMetrics, PluginFactory pluginFactory, PipelineDescription pipelineDescription) {
        this(oTelTraceSourceConfig, pluginMetrics, pluginFactory, new CertificateProviderFactory(oTelTraceSourceConfig), pipelineDescription);
    }

    OTelTraceSource(OTelTraceSourceConfig oTelTraceSourceConfig, PluginMetrics pluginMetrics, PluginFactory pluginFactory, CertificateProviderFactory certificateProviderFactory, PipelineDescription pipelineDescription) {
        oTelTraceSourceConfig.validateAndInitializeCertAndKeyFileInS3();
        this.oTelTraceSourceConfig = oTelTraceSourceConfig;
        this.pluginMetrics = pluginMetrics;
        this.certificateProviderFactory = certificateProviderFactory;
        this.pipelineName = pipelineDescription.getPipelineName();
        this.authenticationProvider = this.createAuthenticationProvider(pluginFactory);
        this.byteDecoder = new OTelTraceDecoder(oTelTraceSourceConfig.getOutputFormat());
    }

    public ByteDecoder getDecoder() {
        return this.byteDecoder;
    }

    public void start(Buffer<Record<Object>> buffer) {
        if (buffer == null) {
            throw new IllegalStateException("Buffer provided is null");
        }
        if (this.server == null) {
            OTelTraceGrpcService oTelTraceGrpcService = new OTelTraceGrpcService((int)((double)this.oTelTraceSourceConfig.getRequestTimeoutInMillis() * 0.8), (OTelProtoCodec.OTelProtoDecoder)(this.oTelTraceSourceConfig.getOutputFormat() == OTelOutputFormat.OPENSEARCH ? new OTelProtoOpensearchCodec.OTelProtoDecoder() : new OTelProtoStandardCodec.OTelProtoDecoder()), buffer, this.pluginMetrics);
            ServerConfiguration serverConfiguration = ConvertConfiguration.convertConfiguration(this.oTelTraceSourceConfig);
            CreateServer createServer = new CreateServer(serverConfiguration, LOG, this.pluginMetrics, PLUGIN_NAME, this.pipelineName);
            CertificateProvider certificateProvider = null;
            if (this.oTelTraceSourceConfig.isSsl() || this.oTelTraceSourceConfig.useAcmCertForSSL()) {
                certificateProvider = this.certificateProviderFactory.getCertificateProvider();
            }
            MethodDescriptor methodDescriptor = TraceServiceGrpc.getExportMethod();
            this.server = createServer.createGRPCServer(this.authenticationProvider, (BindableService)oTelTraceGrpcService, certificateProvider, methodDescriptor);
            this.pluginMetrics.gauge(SERVER_CONNECTIONS, (Object)this.server, Server::numConnections);
        }
        try {
            this.server.start().get();
        }
        catch (ExecutionException ex) {
            if (ex.getCause() != null && ex.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause();
            }
            throw new RuntimeException(ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(ex);
        }
        LOG.info("Started otel_trace_source on port " + this.oTelTraceSourceConfig.getPort() + "...");
    }

    public void stop() {
        if (this.server != null) {
            try {
                this.server.stop().get();
            }
            catch (ExecutionException ex) {
                if (ex.getCause() != null && ex.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)ex.getCause();
                }
                throw new RuntimeException(ex);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(ex);
            }
        }
        LOG.info("Stopped otel_trace_source.");
    }

    private GrpcAuthenticationProvider createAuthenticationProvider(PluginFactory pluginFactory) {
        PluginModel authenticationConfiguration = this.oTelTraceSourceConfig.getAuthentication();
        if (authenticationConfiguration == null || authenticationConfiguration.getPluginName().equals("unauthenticated")) {
            LOG.warn("Creating otel-trace-source without authentication. This is not secure.");
            LOG.warn("In order to set up Http Basic authentication for the otel-trace-source, go here: https://github.com/opensearch-project/data-prepper/tree/main/data-prepper-plugins/otel-trace-source#authentication-configurations");
        }
        PluginSetting authenticationPluginSetting = authenticationConfiguration != null ? new PluginSetting(authenticationConfiguration.getPluginName(), authenticationConfiguration.getPluginSettings()) : new PluginSetting("unauthenticated", Collections.emptyMap());
        authenticationPluginSetting.setPipelineName(this.pipelineName);
        return (GrpcAuthenticationProvider)pluginFactory.loadPlugin(GrpcAuthenticationProvider.class, authenticationPluginSetting, new Object[0]);
    }
}

