/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.otel.codec;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum OTelOutputFormat {
    OTEL("otel"),
    OPENSEARCH("opensearch");

    private static final Map<String, OTelOutputFormat> NAMES_MAP;
    private final String optionName;

    private OTelOutputFormat(String optionName) {
        this.optionName = optionName;
    }

    @JsonValue
    public String getFormatName() {
        return this.optionName;
    }

    @JsonCreator
    public static OTelOutputFormat fromFormatName(String optionName) {
        return NAMES_MAP.get(optionName);
    }

    static {
        NAMES_MAP = Arrays.stream(OTelOutputFormat.values()).collect(Collectors.toMap(value -> value.optionName, value -> value));
    }
}

