/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.sourcecoordination;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micrometer.core.instrument.Counter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.opensearch.dataprepper.core.parser.model.SourceCoordinationConfig;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.source.SourceCoordinationStore;
import org.opensearch.dataprepper.model.source.coordinator.PartitionIdentifier;
import org.opensearch.dataprepper.model.source.coordinator.SourceCoordinator;
import org.opensearch.dataprepper.model.source.coordinator.SourcePartition;
import org.opensearch.dataprepper.model.source.coordinator.SourcePartitionStatus;
import org.opensearch.dataprepper.model.source.coordinator.SourcePartitionStoreItem;
import org.opensearch.dataprepper.model.source.coordinator.exceptions.PartitionNotFoundException;
import org.opensearch.dataprepper.model.source.coordinator.exceptions.PartitionNotOwnedException;
import org.opensearch.dataprepper.model.source.coordinator.exceptions.PartitionUpdateException;
import org.opensearch.dataprepper.model.source.coordinator.exceptions.UninitializedSourceCoordinatorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaseBasedSourceCoordinator<T>
implements SourceCoordinator<T> {
    private static final Logger LOG = LoggerFactory.getLogger(LeaseBasedSourceCoordinator.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final String COMPLETE_ACTION = "complete";
    private static final String CLOSE_ACTION = "close";
    private static final String SAVE_STATE_ACTION = "saveState";
    static final String PARTITION_CREATION_SUPPLIER_INVOCATION_COUNT = "partitionCreationSupplierInvocations";
    static final String NO_PARTITIONS_ACQUIRED_COUNT = "noPartitionsAcquired";
    static final String PARTITION_CREATED_COUNT = "partitionsCreatedCount";
    static final String PARTITIONS_ACQUIRED_COUNT = "partitionsAcquired";
    static final String PARTITIONS_COMPLETED_COUNT = "partitionsCompleted";
    static final String PARTITIONS_CLOSED_COUNT = "partitionsClosed";
    static final String PARTITIONS_DELETED = "partitionsDeleted";
    static final String SAVE_PROGRESS_STATE_INVOCATION_SUCCESS_COUNT = "savePartitionProgressStateInvocationsSuccess";
    static final String PARTITION_OWNERSHIP_GIVEN_UP_COUNT = "partitionsGivenUp";
    static final String PARTITION_NOT_FOUND_ERROR_COUNT = "partitionNotFoundErrors";
    static final String PARTITION_NOT_OWNED_ERROR_COUNT = "partitionNotOwnedErrors";
    static final String PARTITION_UPDATE_ERROR_COUNT = "PartitionUpdateErrors";
    static final Duration DEFAULT_LEASE_TIMEOUT = Duration.ofMinutes(10L);
    private static final String hostName;
    static final String PARTITION_TYPE = "PARTITION";
    static final String GLOBAL_STATE_TYPE = "GLOBAL_STATE";
    static final String GLOBAL_STATE_SOURCE_PARTITION_KEY_FOR_CREATING_PARTITIONS = "GLOBAL_STATE_SOURCE_PARTITION_KEY_FOR_CREATING_PARTITIONS";
    private final SourceCoordinationConfig sourceCoordinationConfig;
    private final SourceCoordinationStore sourceCoordinationStore;
    private final Class<T> partitionProgressStateClass;
    private final String ownerId;
    private final String sourceIdentifier;
    private final String sourceIdentifierWithPartitionType;
    private final String sourceIdentifierWithGlobalStateType;
    private boolean initialized = false;
    private final PluginMetrics pluginMetrics;
    private final Counter partitionCreationSupplierInvocationsCounter;
    private final Counter partitionsCreatedCounter;
    private final Counter noPartitionsAcquiredCounter;
    private final Counter partitionsAcquiredCounter;
    private final Counter partitionsCompletedCounter;
    private final Counter partitionsClosedCounter;
    private final Counter saveProgressStateInvocationSuccessCounter;
    private final Counter partitionsGivenUpCounter;
    private final Counter partitionNotFoundErrorCounter;
    private final Counter partitionNotOwnedErrorCounter;
    private final Counter saveStatePartitionUpdateErrorCounter;
    private final Counter closePartitionUpdateErrorCounter;
    private final Counter completePartitionUpdateErrorCounter;
    private final Counter partitionsDeleted;
    private final ReentrantLock lock;
    private Instant lastSupplierRunTime;
    static final Duration FORCE_SUPPLIER_AFTER_DURATION;

    public LeaseBasedSourceCoordinator(Class<T> partitionProgressStateClass, SourceCoordinationStore sourceCoordinationStore, SourceCoordinationConfig sourceCoordinationConfig, String sourceIdentifier, PluginMetrics pluginMetrics) {
        this.sourceCoordinationConfig = sourceCoordinationConfig;
        this.sourceCoordinationStore = sourceCoordinationStore;
        this.partitionProgressStateClass = partitionProgressStateClass;
        this.sourceIdentifier = Objects.nonNull(sourceCoordinationConfig.getPartitionPrefix()) ? sourceCoordinationConfig.getPartitionPrefix() + "|" + sourceIdentifier : sourceIdentifier;
        this.sourceIdentifierWithPartitionType = this.sourceIdentifier + "|PARTITION";
        this.sourceIdentifierWithGlobalStateType = this.sourceIdentifier + "|GLOBAL_STATE";
        this.ownerId = this.sourceIdentifier + ":" + hostName;
        this.pluginMetrics = pluginMetrics;
        this.partitionCreationSupplierInvocationsCounter = pluginMetrics.counter(PARTITION_CREATION_SUPPLIER_INVOCATION_COUNT);
        this.partitionsCreatedCounter = pluginMetrics.counter(PARTITION_CREATED_COUNT);
        this.noPartitionsAcquiredCounter = pluginMetrics.counter(NO_PARTITIONS_ACQUIRED_COUNT);
        this.partitionsAcquiredCounter = pluginMetrics.counter(PARTITIONS_ACQUIRED_COUNT);
        this.partitionsCompletedCounter = pluginMetrics.counter(PARTITIONS_COMPLETED_COUNT);
        this.partitionsClosedCounter = pluginMetrics.counter(PARTITIONS_CLOSED_COUNT);
        this.saveProgressStateInvocationSuccessCounter = pluginMetrics.counter(SAVE_PROGRESS_STATE_INVOCATION_SUCCESS_COUNT);
        this.partitionsGivenUpCounter = pluginMetrics.counter(PARTITION_OWNERSHIP_GIVEN_UP_COUNT);
        this.partitionNotFoundErrorCounter = pluginMetrics.counter(PARTITION_NOT_FOUND_ERROR_COUNT);
        this.partitionNotOwnedErrorCounter = pluginMetrics.counter(PARTITION_NOT_OWNED_ERROR_COUNT);
        this.saveStatePartitionUpdateErrorCounter = pluginMetrics.counter(PARTITION_UPDATE_ERROR_COUNT, SAVE_STATE_ACTION);
        this.closePartitionUpdateErrorCounter = pluginMetrics.counter(PARTITION_UPDATE_ERROR_COUNT, CLOSE_ACTION);
        this.completePartitionUpdateErrorCounter = pluginMetrics.counter(PARTITION_UPDATE_ERROR_COUNT, COMPLETE_ACTION);
        this.partitionsDeleted = pluginMetrics.counter(PARTITIONS_DELETED);
        this.lock = new ReentrantLock();
        this.lastSupplierRunTime = Instant.now();
    }

    public void initialize() {
        this.sourceCoordinationStore.initializeStore();
        this.initialized = true;
        this.sourceCoordinationStore.tryCreatePartitionItem(this.sourceIdentifierWithGlobalStateType, GLOBAL_STATE_SOURCE_PARTITION_KEY_FOR_CREATING_PARTITIONS, SourcePartitionStatus.UNASSIGNED, Long.valueOf(0L), null, false);
    }

    public Optional<SourcePartition<T>> getNextPartition(Function<Map<String, Object>, List<PartitionIdentifier>> partitionCreationSupplier) {
        return this.getNextPartitionInternal(partitionCreationSupplier, false);
    }

    public Optional<SourcePartition<T>> getNextPartition(Function<Map<String, Object>, List<PartitionIdentifier>> partitionCreationSupplier, boolean forceSupplierEnabled) {
        if (forceSupplierEnabled && Instant.now().isAfter(this.lastSupplierRunTime.plus(FORCE_SUPPLIER_AFTER_DURATION))) {
            return this.getNextPartitionInternal(partitionCreationSupplier, true);
        }
        return this.getNextPartitionInternal(partitionCreationSupplier, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<SourcePartition<T>> getNextPartitionInternal(Function<Map<String, Object>, List<PartitionIdentifier>> partitionCreationSupplier, boolean forceSupplier) {
        this.validateIsInitialized();
        Optional ownedPartitions = this.sourceCoordinationStore.tryAcquireAvailablePartition(this.sourceIdentifierWithPartitionType, this.ownerId, DEFAULT_LEASE_TIMEOUT);
        try {
            if ((ownedPartitions.isEmpty() || forceSupplier) && this.lock.tryLock()) {
                this.lastSupplierRunTime = Instant.now();
                Optional<SourcePartitionStoreItem> acquiredGlobalStateForPartitionCreation = this.acquireGlobalStateForPartitionCreation();
                if (acquiredGlobalStateForPartitionCreation.isPresent()) {
                    Map<String, Object> globalStateMap = this.convertStringToGlobalStateMap(acquiredGlobalStateForPartitionCreation.get().getPartitionProgressState());
                    LOG.info("Partition owner {} did not acquire any partitions. Running partition creation supplier to create more partitions", (Object)this.ownerId);
                    this.createPartitions(partitionCreationSupplier.apply(globalStateMap));
                    this.partitionCreationSupplierInvocationsCounter.increment();
                    this.giveUpAndSaveGlobalStateForPartitionCreation(acquiredGlobalStateForPartitionCreation.get(), globalStateMap);
                }
            }
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
            if (ownedPartitions.isEmpty()) {
                ownedPartitions = this.sourceCoordinationStore.tryAcquireAvailablePartition(this.sourceIdentifierWithPartitionType, this.ownerId, DEFAULT_LEASE_TIMEOUT);
            }
        }
        if (ownedPartitions.isEmpty()) {
            LOG.info("Partition owner {} did not acquire any partitions even after running the partition creation supplier", (Object)this.ownerId);
            this.noPartitionsAcquiredCounter.increment();
            return Optional.empty();
        }
        SourcePartition sourcePartition = SourcePartition.builder(this.partitionProgressStateClass).withPartitionKey(((SourcePartitionStoreItem)ownedPartitions.get()).getSourcePartitionKey()).withPartitionState(this.convertStringToPartitionProgressStateClass(((SourcePartitionStoreItem)ownedPartitions.get()).getPartitionProgressState())).withPartitionClosedCount(((SourcePartitionStoreItem)ownedPartitions.get()).getClosedCount()).build();
        LOG.debug("Partition key {} was acquired by owner {}", (Object)sourcePartition.getPartitionKey(), (Object)this.ownerId);
        this.partitionsAcquiredCounter.increment();
        return Optional.of(sourcePartition);
    }

    private void createPartitions(List<PartitionIdentifier> partitionIdentifiers) {
        for (PartitionIdentifier partitionIdentifier : partitionIdentifiers) {
            boolean partitionCreated;
            Optional optionalPartitionItem = this.sourceCoordinationStore.getSourcePartitionItem(this.sourceIdentifierWithPartitionType, partitionIdentifier.getPartitionKey());
            if (optionalPartitionItem.isPresent() || !(partitionCreated = this.sourceCoordinationStore.tryCreatePartitionItem(this.sourceIdentifierWithPartitionType, partitionIdentifier.getPartitionKey(), SourcePartitionStatus.UNASSIGNED, Long.valueOf(0L), null, false))) continue;
            LOG.info("Partition successfully created by owner {} for source partition key {}", (Object)this.ownerId, (Object)partitionIdentifier.getPartitionKey());
            this.partitionsCreatedCounter.increment();
        }
    }

    public void completePartition(String partitionKey, Boolean fromAcknowledgmentsCallback) {
        this.validateIsInitialized();
        SourcePartitionStoreItem itemToUpdate = this.getSourcePartitionStoreItem(partitionKey, COMPLETE_ACTION);
        this.validatePartitionOwnership(itemToUpdate);
        itemToUpdate.setPartitionOwner(null);
        itemToUpdate.setReOpenAt(null);
        itemToUpdate.setPartitionOwnershipTimeout(null);
        itemToUpdate.setSourcePartitionStatus(SourcePartitionStatus.COMPLETED);
        try {
            this.sourceCoordinationStore.tryUpdateSourcePartitionItem(itemToUpdate);
        }
        catch (PartitionUpdateException e) {
            this.completePartitionUpdateErrorCounter.increment();
            throw e;
        }
        LOG.info("Partition key {} was completed by owner {}.", (Object)partitionKey, (Object)this.ownerId);
        this.partitionsCompletedCounter.increment();
    }

    public void closePartition(String partitionKey, Duration reopenAfter, int maxClosedCount, Boolean fromAcknowledgmentsCallback) {
        this.validateIsInitialized();
        SourcePartitionStoreItem itemToUpdate = this.getSourcePartitionStoreItem(partitionKey, CLOSE_ACTION);
        this.validatePartitionOwnership(itemToUpdate);
        itemToUpdate.setPartitionOwner(null);
        itemToUpdate.setPartitionOwnershipTimeout(null);
        itemToUpdate.setPartitionProgressState(null);
        itemToUpdate.setClosedCount(Long.valueOf(itemToUpdate.getClosedCount() + 1L));
        if (itemToUpdate.getClosedCount() >= (long)maxClosedCount) {
            itemToUpdate.setSourcePartitionStatus(SourcePartitionStatus.COMPLETED);
            itemToUpdate.setReOpenAt(null);
        } else {
            itemToUpdate.setSourcePartitionStatus(SourcePartitionStatus.CLOSED);
            itemToUpdate.setReOpenAt(Instant.now().plus(reopenAfter));
        }
        try {
            this.sourceCoordinationStore.tryUpdateSourcePartitionItem(itemToUpdate);
        }
        catch (PartitionUpdateException e) {
            if (SourcePartitionStatus.COMPLETED.equals((Object)itemToUpdate.getSourcePartitionStatus())) {
                this.completePartitionUpdateErrorCounter.increment();
            } else {
                this.closePartitionUpdateErrorCounter.increment();
            }
            throw e;
        }
        if (SourcePartitionStatus.COMPLETED.equals((Object)itemToUpdate.getSourcePartitionStatus())) {
            this.partitionsCompletedCounter.increment();
        } else {
            this.partitionsClosedCounter.increment();
        }
        LOG.info("Partition key {} was closed by owner {}. The resulting status of the partition is now {}", new Object[]{partitionKey, this.ownerId, itemToUpdate.getSourcePartitionStatus()});
    }

    public <S extends T> void saveProgressStateForPartition(String partitionKey, S partitionProgressState) {
        this.validateIsInitialized();
        SourcePartitionStoreItem itemToUpdate = this.getSourcePartitionStoreItem(partitionKey, SAVE_STATE_ACTION);
        this.validatePartitionOwnership(itemToUpdate);
        itemToUpdate.setPartitionOwnershipTimeout(Instant.now().plus(DEFAULT_LEASE_TIMEOUT));
        itemToUpdate.setPartitionProgressState(this.convertPartitionProgressStateClasstoString(partitionProgressState));
        try {
            this.sourceCoordinationStore.tryUpdateSourcePartitionItem(itemToUpdate);
        }
        catch (Exception e) {
            LOG.error("Exception while saving state for the partition {}: {}", (Object)partitionKey, (Object)e.getMessage());
            this.saveStatePartitionUpdateErrorCounter.increment();
            throw e;
        }
        LOG.debug("State was saved for partition key {} by owner {}. The saved state is: {}", new Object[]{partitionKey, this.ownerId, itemToUpdate.getPartitionProgressState()});
        this.saveProgressStateInvocationSuccessCounter.increment();
    }

    public void updatePartitionForAcknowledgmentWait(String partitionKey, Duration ackowledgmentTimeout) {
        try {
            this.updatePartitionOwnership(partitionKey, ackowledgmentTimeout);
        }
        catch (Exception e) {
            LOG.error("Exception while updating acknowledgment wait for the partition {}: {}", (Object)partitionKey, (Object)e.getMessage());
            throw e;
        }
    }

    public void renewPartitionOwnership(String partitionKey) {
        try {
            this.updatePartitionOwnership(partitionKey, DEFAULT_LEASE_TIMEOUT);
        }
        catch (Exception e) {
            LOG.error("Exception while renewing partition ownership for the partition {}: {}", (Object)partitionKey, (Object)e.getMessage());
            throw e;
        }
    }

    private void updatePartitionOwnership(String partitionKey, Duration ownershipRenewalTime) {
        SourcePartitionStoreItem itemToUpdate = this.getSourcePartitionStoreItem(partitionKey, "update partition ownership");
        this.validatePartitionOwnership(itemToUpdate);
        itemToUpdate.setPartitionOwnershipTimeout(Instant.now().plus(ownershipRenewalTime));
        this.sourceCoordinationStore.tryUpdateSourcePartitionItem(itemToUpdate);
    }

    public void giveUpPartition(String partitionKey) {
        this.giveUpPartitionInternal(partitionKey, null);
    }

    public void giveUpPartition(String partitionKey, Instant priorityTimestamp) {
        this.giveUpPartitionInternal(partitionKey, priorityTimestamp);
    }

    public void giveUpPartition(String partitionKey, Instant priorityTimestamp, Integer maxRetries) {
        long backoffMillis = 200L;
        for (int attempt = 1; attempt <= maxRetries; ++attempt) {
            try {
                this.giveUpPartitionInternal(partitionKey, priorityTimestamp);
                return;
            }
            catch (PartitionNotOwnedException e) {
                if (attempt == maxRetries) {
                    throw e;
                }
                LOG.warn("Partition {} not owned on attempt {}/{}. Will retry giving up the partition", new Object[]{partitionKey, attempt, maxRetries});
                try {
                    Thread.sleep(200L);
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    LOG.warn("Interrupted while retrying giveUpPartition for partition {} with message {}", (Object)partitionKey, (Object)ie);
                    throw new RuntimeException(ie);
                }
            }
        }
    }

    private void giveUpPartitionInternal(String partitionKey, Instant priorityTimestamp) {
        if (!this.initialized) {
            return;
        }
        Optional optionalItem = this.sourceCoordinationStore.getSourcePartitionItem(this.sourceIdentifierWithPartitionType, partitionKey);
        if (optionalItem.isPresent()) {
            SourcePartitionStoreItem updateItem = (SourcePartitionStoreItem)optionalItem.get();
            this.validatePartitionOwnership(updateItem);
            updateItem.setSourcePartitionStatus(SourcePartitionStatus.UNASSIGNED);
            updateItem.setPartitionOwner(null);
            updateItem.setPartitionOwnershipTimeout(null);
            try {
                this.sourceCoordinationStore.tryUpdateSourcePartitionItem(updateItem, priorityTimestamp);
            }
            catch (PartitionUpdateException e) {
                LOG.info("Unable to explicitly give up partition {}. Partition can be considered given up.", (Object)updateItem.getSourcePartitionKey());
            }
            LOG.info("Partition key {} was given up by owner {}", (Object)updateItem.getSourcePartitionKey(), (Object)this.ownerId);
        }
        this.partitionsGivenUpCounter.increment();
    }

    public void deletePartition(String partitionKey) {
        Optional optionalItem = this.sourceCoordinationStore.getSourcePartitionItem(this.sourceIdentifierWithPartitionType, partitionKey);
        if (optionalItem.isPresent()) {
            SourcePartitionStoreItem deleteItem = (SourcePartitionStoreItem)optionalItem.get();
            this.validatePartitionOwnership(deleteItem);
            try {
                this.sourceCoordinationStore.tryDeletePartitionItem(deleteItem);
            }
            catch (PartitionUpdateException e) {
                LOG.error("Unable to delete partition {}: {}.", (Object)deleteItem.getSourcePartitionKey(), (Object)e.getMessage());
                return;
            }
            this.partitionsDeleted.increment();
            LOG.info("Partition key {} was deleted by owner {}", (Object)deleteItem.getSourcePartitionKey(), (Object)this.ownerId);
        }
    }

    private T convertStringToPartitionProgressStateClass(String serializedPartitionProgressState) {
        if (Objects.isNull(serializedPartitionProgressState)) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(serializedPartitionProgressState, this.partitionProgressStateClass);
        }
        catch (JsonProcessingException e) {
            LOG.error("Unable to convert string to partition progress state class {}", (Object)this.partitionProgressStateClass.getName(), (Object)e);
            return null;
        }
    }

    private String convertPartitionProgressStateClasstoString(T partitionProgressState) {
        try {
            return objectMapper.writeValueAsString(partitionProgressState);
        }
        catch (JsonProcessingException e) {
            LOG.error("Unable to convert partition progress state class {} to string", (Object)this.partitionProgressStateClass.getName(), (Object)e);
            return null;
        }
    }

    private Map<String, Object> convertStringToGlobalStateMap(String serializedGlobalState) {
        if (Objects.isNull(serializedGlobalState)) {
            return new HashMap<String, Object>();
        }
        try {
            return (Map)objectMapper.readValue(serializedGlobalState, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (JsonProcessingException e) {
            LOG.error("Unable to convert global state string to Map<String, Object>", (Throwable)e);
            return new HashMap<String, Object>();
        }
    }

    private void validatePartitionOwnership(SourcePartitionStoreItem item) {
        if (Objects.isNull(item.getPartitionOwner()) || !this.ownerId.equals(item.getPartitionOwner())) {
            this.partitionNotOwnedErrorCounter.increment();
            throw new PartitionNotOwnedException(String.format("The partition is no longer owned by this instance of Data Prepper. The partition ownership timeout most likely expired and was grabbed by another instance of Data Prepper for partition owner %s and partition key %s.", this.ownerId, item.getSourcePartitionKey()));
        }
    }

    private SourcePartitionStoreItem getSourcePartitionStoreItem(String partitionKey, String action) {
        Optional optionalPartitionItem = this.sourceCoordinationStore.getSourcePartitionItem(this.sourceIdentifierWithPartitionType, partitionKey);
        if (optionalPartitionItem.isEmpty()) {
            this.partitionNotFoundErrorCounter.increment();
            throw new PartitionNotFoundException(String.format("Unable to %s for the partition because partition key %s was not found by owner %s", action, partitionKey, this.ownerId));
        }
        return (SourcePartitionStoreItem)optionalPartitionItem.get();
    }

    private void validateIsInitialized() {
        if (!this.initialized) {
            throw new UninitializedSourceCoordinatorException("The initialize method has not been called on this source coordinator. initialize() must be called before further interactions with the SourceCoordinator");
        }
    }

    private Optional<SourcePartitionStoreItem> acquireGlobalStateForPartitionCreation() {
        Optional globalStateItemForPartitionCreation = this.sourceCoordinationStore.getSourcePartitionItem(this.sourceIdentifierWithGlobalStateType, GLOBAL_STATE_SOURCE_PARTITION_KEY_FOR_CREATING_PARTITIONS);
        if (globalStateItemForPartitionCreation.isPresent()) {
            if (SourcePartitionStatus.ASSIGNED.equals((Object)((SourcePartitionStoreItem)globalStateItemForPartitionCreation.get()).getSourcePartitionStatus()) && (Objects.isNull(((SourcePartitionStoreItem)globalStateItemForPartitionCreation.get()).getPartitionOwnershipTimeout()) || Instant.now().isAfter(((SourcePartitionStoreItem)globalStateItemForPartitionCreation.get()).getPartitionOwnershipTimeout()) || this.ownerId.equals(((SourcePartitionStoreItem)globalStateItemForPartitionCreation.get()).getPartitionOwner()))) {
                LOG.warn("The global state item for partition creation is owned by {}, but the ownership has expired. Attempting to acquire global state for owner {}", (Object)((SourcePartitionStoreItem)globalStateItemForPartitionCreation.get()).getPartitionOwner(), (Object)this.ownerId);
            } else if (Objects.nonNull(((SourcePartitionStoreItem)globalStateItemForPartitionCreation.get()).getPartitionOwner()) && !this.ownerId.equals(((SourcePartitionStoreItem)globalStateItemForPartitionCreation.get()).getPartitionOwner()) || !SourcePartitionStatus.UNASSIGNED.equals((Object)((SourcePartitionStoreItem)globalStateItemForPartitionCreation.get()).getSourcePartitionStatus())) {
                return Optional.empty();
            }
            try {
                ((SourcePartitionStoreItem)globalStateItemForPartitionCreation.get()).setSourcePartitionStatus(SourcePartitionStatus.ASSIGNED);
                ((SourcePartitionStoreItem)globalStateItemForPartitionCreation.get()).setPartitionOwner(this.ownerId);
                ((SourcePartitionStoreItem)globalStateItemForPartitionCreation.get()).setPartitionOwnershipTimeout(Instant.now().plus(DEFAULT_LEASE_TIMEOUT));
                this.sourceCoordinationStore.tryUpdateSourcePartitionItem((SourcePartitionStoreItem)globalStateItemForPartitionCreation.get());
            }
            catch (PartitionUpdateException e) {
                LOG.debug("Owner %s was not able to acquire the global state item to create new partitions. This means that another instance of Data Prepper has gained the responsibility of creating partitions at this time");
                return Optional.empty();
            }
        }
        return globalStateItemForPartitionCreation;
    }

    private void giveUpAndSaveGlobalStateForPartitionCreation(SourcePartitionStoreItem globalStateItemForPartitionCreation, Map<String, Object> globalStateMap) {
        globalStateItemForPartitionCreation.setSourcePartitionStatus(SourcePartitionStatus.UNASSIGNED);
        globalStateItemForPartitionCreation.setPartitionOwner(null);
        globalStateItemForPartitionCreation.setPartitionOwnershipTimeout(null);
        try {
            globalStateItemForPartitionCreation.setPartitionProgressState(objectMapper.writeValueAsString(globalStateMap));
            this.sourceCoordinationStore.tryUpdateSourcePartitionItem(globalStateItemForPartitionCreation);
        }
        catch (JsonProcessingException | PartitionUpdateException e) {
            LOG.warn("There was an error saving global state after creating partitions.", e);
        }
    }

    static {
        FORCE_SUPPLIER_AFTER_DURATION = Duration.ofMinutes(5L);
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }
}

