/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.pipeline.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.core.pipeline.PipelinesProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListPipelinesHandler
implements HttpHandler {
    private final PipelinesProvider pipelinesProvider;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final Logger LOG = LoggerFactory.getLogger(ListPipelinesHandler.class);

    public ListPipelinesHandler(PipelinesProvider pipelinesProvider) {
        this.pipelinesProvider = pipelinesProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange exchange) throws IOException {
        String requestMethod = exchange.getRequestMethod();
        if (!requestMethod.equals("GET") && !requestMethod.equals("POST")) {
            exchange.sendResponseHeaders(405, 0L);
            exchange.getResponseBody().close();
            return;
        }
        try {
            List pipelines = this.pipelinesProvider.getTransformationPipelines().keySet().stream().map(PipelineListing::new).collect(Collectors.toList());
            this.LOG.debug("List pipelines request responding with {} pipelines.", (Object)pipelines.size());
            byte[] response = OBJECT_MAPPER.writeValueAsString(Collections.singletonMap("pipelines", pipelines)).getBytes();
            exchange.getResponseHeaders().add("Content-Type", "text/plain; charset=UTF-8");
            exchange.sendResponseHeaders(200, response.length);
            exchange.getResponseBody().write(response);
        }
        catch (Exception e) {
            this.LOG.error("Caught exception listing pipelines", (Throwable)e);
            exchange.sendResponseHeaders(500, 0L);
        }
        finally {
            exchange.getResponseBody().close();
        }
    }

    private static class PipelineListing {
        public String name;

        public PipelineListing(String name) {
            this.name = name;
        }
    }
}

