/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.pipeline.common;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.opensearch.dataprepper.core.pipeline.Pipeline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(PipelineThreadPoolExecutor.class);
    private final Pipeline pipeline;

    public PipelineThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, Pipeline pipeline) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        this.pipeline = pipeline;
    }

    public static PipelineThreadPoolExecutor newFixedThreadPool(int nThreads, ThreadFactory threadFactory, Pipeline pipeline) {
        return new PipelineThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory, pipeline);
    }

    @Override
    public void afterExecute(Runnable runnable, Throwable throwable) {
        super.afterExecute(runnable, throwable);
        if (throwable == null && runnable instanceof Future) {
            try {
                ((Future)((Object)runnable)).get();
            }
            catch (CancellationException | ExecutionException ex) {
                LOG.error("Pipeline [{}] process worker encountered a fatal exception, cannot proceed further", (Object)this.pipeline.getName(), (Object)ex);
                this.pipeline.shutdown();
            }
            catch (InterruptedException ex) {
                LOG.error("Pipeline [{}] process worker encountered a fatal exception, terminating", (Object)this.pipeline.getName(), (Object)ex);
                this.pipeline.shutdown();
                Thread.currentThread().interrupt();
            }
        } else if (throwable != null) {
            LOG.error("Pipeline {} encountered a fatal exception, terminating", (Object)this.pipeline.getName(), (Object)throwable);
            this.pipeline.shutdown();
        }
    }
}

