/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.pipeline;

import java.util.List;
import org.opensearch.dataprepper.core.pipeline.Pipeline;
import org.opensearch.dataprepper.core.pipeline.PipelineRunner;
import org.opensearch.dataprepper.core.pipeline.PipelineRunnerImpl;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.processor.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessWorker
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessWorker.class);
    private final Buffer readBuffer;
    private final List<Processor> processors;
    private final Pipeline pipeline;
    private final PipelineRunner pipelineRunner;

    public ProcessWorker(Buffer readBuffer, Pipeline pipeline) {
        this.readBuffer = readBuffer;
        this.processors = pipeline.getProcessorProvider().getProcessors();
        this.pipeline = pipeline;
        this.pipelineRunner = new PipelineRunnerImpl(pipeline);
    }

    @Override
    public void run() {
        try {
            while (!this.pipeline.isStopRequested()) {
                this.doRun();
            }
            this.executeShutdownProcess();
        }
        catch (Exception e) {
            LOG.error("Encountered exception during pipeline {} processing", (Object)this.pipeline.getName(), (Object)e);
        }
    }

    private void executeShutdownProcess() {
        LOG.info("Processor shutdown phase 1 complete.");
        LOG.info("Beginning processor shutdown phase 2, iterating until buffers empty.");
        while (!this.isBufferReadyForShutdown()) {
            this.doRun();
        }
        LOG.info("Processor shutdown phase 2 complete.");
        long drainTimeoutExpiration = System.currentTimeMillis() + this.pipeline.getPeerForwarderDrainTimeout().toMillis();
        LOG.info("Beginning processor shutdown phase 3, iterating until {}.", (Object)drainTimeoutExpiration);
        while (System.currentTimeMillis() < drainTimeoutExpiration) {
            this.doRun();
        }
        LOG.info("Processor shutdown phase 3 complete.");
        LOG.info("Beginning processor shutdown phase 4, preparing processors for shutdown.");
        this.processors.forEach(Processor::prepareForShutdown);
        LOG.info("Processor shutdown phase 4 complete.");
        LOG.info("Beginning processor shutdown phase 5, iterating until processors are ready to shutdown.");
        while (!this.areComponentsReadyForShutdown()) {
            this.doRun();
        }
        LOG.info("Processor shutdown phase 5 complete.");
    }

    private void doRun() {
        this.pipelineRunner.runAllProcessorsAndPublishToSinks();
    }

    private boolean areComponentsReadyForShutdown() {
        return this.isBufferReadyForShutdown() && this.processors.stream().map(Processor::isReadyForShutdown).allMatch(result -> result);
    }

    private boolean isBufferReadyForShutdown() {
        boolean isBufferEmpty = this.readBuffer.isEmpty();
        boolean forceStopReadingBuffers = this.pipeline.isForceStopReadingBuffers();
        boolean isBufferReadyForShutdown = isBufferEmpty || forceStopReadingBuffers;
        LOG.debug("isBufferReadyForShutdown={}, isBufferEmpty={}, forceStopReadingBuffers={}", new Object[]{isBufferReadyForShutdown, isBufferEmpty, forceStopReadingBuffers});
        return isBufferReadyForShutdown;
    }
}

