/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.pipeline;

import java.util.Collection;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.sink.Sink;
import org.opensearch.dataprepper.model.source.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineConnector<T extends Record<?>>
implements Source<T>,
Sink<T> {
    private static final Logger LOG = LoggerFactory.getLogger(PipelineConnector.class);
    private static final int DEFAULT_WRITE_TIMEOUT = Integer.MAX_VALUE;
    private String sourcePipelineName;
    private String sinkPipelineName;
    private Buffer<T> buffer;
    private AtomicBoolean isStopRequested = new AtomicBoolean(false);
    private boolean areAcknowledgementsEnabled = false;
    private boolean ready = false;

    public PipelineConnector() {
    }

    public PipelineConnector(String sinkPipelineName) {
        this();
        this.sinkPipelineName = sinkPipelineName;
    }

    public boolean areAcknowledgementsEnabled() {
        return this.areAcknowledgementsEnabled;
    }

    public void enableAcknowledgements() {
        this.areAcknowledgementsEnabled = true;
    }

    public void start(Buffer<T> buffer) {
        this.buffer = buffer;
        this.ready = true;
    }

    public void stop() {
        this.isStopRequested.set(true);
    }

    public void initialize() {
    }

    public boolean isReady() {
        return this.ready;
    }

    public void output(Collection<T> records) {
        if (this.buffer != null && !this.isStopRequested.get()) {
            block2: for (Record record : records) {
                while (true) {
                    try {
                        this.buffer.write(record, Integer.MAX_VALUE);
                        continue block2;
                    }
                    catch (TimeoutException ex) {
                        LOG.error("PipelineConnector [{}-{}]: Timed out writing to pipeline [{}]", new Object[]{this.sinkPipelineName, this.sourcePipelineName, this.sourcePipelineName, ex});
                        continue;
                    }
                    break;
                }
            }
        } else {
            LOG.error("PipelineConnector [{}-{}]: Pipeline [{}] is currently not initialized or has been halted", new Object[]{this.sinkPipelineName, this.sourcePipelineName, this.sourcePipelineName});
            throw new RuntimeException(String.format("PipelineConnector [%s-%s]: Pipeline [%s] is not active, cannot proceed", this.sinkPipelineName, this.sourcePipelineName, this.sourcePipelineName));
        }
    }

    public void shutdown() {
    }

    public void setSourcePipelineName(String sourcePipelineName) {
        this.sourcePipelineName = sourcePipelineName;
    }

    public void setSinkPipelineName(String sinkPipelineName) {
        this.sinkPipelineName = sinkPipelineName;
    }
}

