/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.peerforwarder.client;

import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.common.AggregatedHttpResponse;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Timer;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.core.peerforwarder.PeerClientPool;
import org.opensearch.dataprepper.core.peerforwarder.PeerForwarderClientFactory;
import org.opensearch.dataprepper.core.peerforwarder.PeerForwarderConfiguration;
import org.opensearch.dataprepper.core.peerforwarder.codec.PeerForwarderCodec;
import org.opensearch.dataprepper.core.peerforwarder.model.PeerForwardingEvents;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.record.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerForwarderClient {
    private static final Logger LOG = LoggerFactory.getLogger(PeerForwarderClient.class);
    static final String REQUESTS = "requests";
    static final String CLIENT_REQUEST_FORWARDING_LATENCY = "clientRequestForwardingLatency";
    private final PeerForwarderClientFactory peerForwarderClientFactory;
    private final PeerForwarderConfiguration peerForwarderConfiguration;
    private final PeerForwarderCodec peerForwarderCodec;
    private final ExecutorService executorService;
    private final Counter requestsCounter;
    private final Timer clientRequestForwardingLatencyTimer;
    private PeerClientPool peerClientPool;

    public PeerForwarderClient(PeerForwarderConfiguration peerForwarderConfiguration, PeerForwarderClientFactory peerForwarderClientFactory, PeerForwarderCodec peerForwarderCodec, PluginMetrics pluginMetrics) {
        this.peerForwarderConfiguration = peerForwarderConfiguration;
        this.peerForwarderClientFactory = peerForwarderClientFactory;
        this.peerForwarderCodec = peerForwarderCodec;
        this.executorService = Executors.newFixedThreadPool(peerForwarderConfiguration.getClientThreadCount());
        this.requestsCounter = pluginMetrics.counter(REQUESTS);
        this.clientRequestForwardingLatencyTimer = pluginMetrics.timer(CLIENT_REQUEST_FORWARDING_LATENCY);
    }

    public CompletableFuture<AggregatedHttpResponse> serializeRecordsAndSendHttpRequest(Collection<Record<Event>> records, String ipAddress, String pluginId, String pipelineName) {
        if (this.peerClientPool == null) {
            this.peerClientPool = this.peerForwarderClientFactory.setPeerClientPool();
        }
        WebClient client = this.peerClientPool.getClient(ipAddress);
        byte[] serializedJsonBytes = this.getSerializedJsonBytes(records, pluginId, pipelineName);
        CompletableFuture aggregatedHttpResponse = (CompletableFuture)this.clientRequestForwardingLatencyTimer.record(() -> this.processHttpRequest(client, serializedJsonBytes));
        this.requestsCounter.increment();
        return aggregatedHttpResponse;
    }

    private byte[] getSerializedJsonBytes(Collection<Record<Event>> records, String pluginId, String pipelineName) {
        List<Event> eventList = records.stream().map(Record::getData).collect(Collectors.toList());
        PeerForwardingEvents peerForwardingEvents = new PeerForwardingEvents(eventList, pluginId, pipelineName);
        try {
            return this.peerForwarderCodec.serialize(peerForwardingEvents);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private CompletableFuture<AggregatedHttpResponse> processHttpRequest(WebClient client, byte[] content) {
        return CompletableFuture.supplyAsync(() -> {
            CompletableFuture aggregate = client.post("/event/forward", content).aggregate();
            return (AggregatedHttpResponse)aggregate.join();
        }, this.executorService);
    }
}

