/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.peerforwarder;

import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import io.micrometer.core.instrument.Counter;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import org.opensearch.dataprepper.core.peerforwarder.HashRing;
import org.opensearch.dataprepper.core.peerforwarder.PeerForwarder;
import org.opensearch.dataprepper.core.peerforwarder.PeerForwarderReceiveBuffer;
import org.opensearch.dataprepper.core.peerforwarder.client.PeerForwarderClient;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.CheckpointState;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.record.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RemotePeerForwarder
implements PeerForwarder {
    private static final Logger LOG = LoggerFactory.getLogger(RemotePeerForwarder.class);
    static final String RECORDS_ACTUALLY_PROCESSED_LOCALLY = "recordsActuallyProcessedLocally";
    static final String RECORDS_TO_BE_PROCESSED_LOCALLY = "recordsToBeProcessedLocally";
    static final String RECORDS_TO_BE_FORWARDED = "recordsToBeForwarded";
    static final String RECORDS_SUCCESSFULLY_FORWARDED = "recordsSuccessfullyForwarded";
    static final String RECORDS_FAILED_FORWARDING = "recordsFailedForwarding";
    static final String RECORDS_MISSING_IDENTIFICATION_KEYS = "recordsMissingIdentificationKeys";
    static final String REQUESTS_FAILED = "requestsFailed";
    static final String REQUESTS_SUCCESSFUL = "requestsSuccessful";
    private final PeerForwarderClient peerForwarderClient;
    private final HashRing hashRing;
    private final PeerForwarderReceiveBuffer<Record<Event>> peerForwarderReceiveBuffer;
    private final String pipelineName;
    private final String pluginId;
    private final Set<String> identificationKeys;
    final ConcurrentHashMap<String, LinkedBlockingQueue<Record<Event>>> peerBatchingQueueMap;
    private final ConcurrentHashMap<String, Long> peerBatchingLastFlushTimeMap;
    private final Counter recordsActuallyProcessedLocallyCounter;
    private final Counter recordsToBeProcessedLocallyCounter;
    private final Counter recordsToBeForwardedCounter;
    private final Counter recordsSuccessfullyForwardedCounter;
    private final Counter recordsFailedForwardingCounter;
    private final Counter recordsMissingIdentificationKeys;
    private final Counter requestsFailedCounter;
    private final Counter requestsSuccessfulCounter;
    private final Integer batchDelay;
    private final Integer failedForwardingRequestLocalWriteTimeout;
    private final Integer forwardingBatchSize;
    private final Integer forwardingBatchQueueDepth;
    private final Duration forwardingBatchTimeout;
    private final Integer pipelineWorkerThreads;

    RemotePeerForwarder(PeerForwarderClient peerForwarderClient, HashRing hashRing, PeerForwarderReceiveBuffer<Record<Event>> peerForwarderReceiveBuffer, String pipelineName, String pluginId, Set<String> identificationKeys, PluginMetrics pluginMetrics, Integer batchDelay, Integer failedForwardingRequestLocalWriteTimeout, Integer forwardingBatchSize, Integer forwardingBatchQueueDepth, Duration forwardingBatchTimeout, Integer pipelineWorkerThreads) {
        this.peerForwarderClient = peerForwarderClient;
        this.hashRing = hashRing;
        this.peerForwarderReceiveBuffer = peerForwarderReceiveBuffer;
        this.pipelineName = pipelineName;
        this.pluginId = pluginId;
        this.identificationKeys = identificationKeys;
        this.batchDelay = batchDelay;
        this.failedForwardingRequestLocalWriteTimeout = failedForwardingRequestLocalWriteTimeout;
        this.forwardingBatchSize = forwardingBatchSize;
        this.forwardingBatchQueueDepth = forwardingBatchQueueDepth;
        this.forwardingBatchTimeout = forwardingBatchTimeout;
        this.pipelineWorkerThreads = pipelineWorkerThreads;
        this.peerBatchingQueueMap = new ConcurrentHashMap();
        this.peerBatchingLastFlushTimeMap = new ConcurrentHashMap();
        this.recordsActuallyProcessedLocallyCounter = pluginMetrics.counter(RECORDS_ACTUALLY_PROCESSED_LOCALLY);
        this.recordsToBeProcessedLocallyCounter = pluginMetrics.counter(RECORDS_TO_BE_PROCESSED_LOCALLY);
        this.recordsToBeForwardedCounter = pluginMetrics.counter(RECORDS_TO_BE_FORWARDED);
        this.recordsSuccessfullyForwardedCounter = pluginMetrics.counter(RECORDS_SUCCESSFULLY_FORWARDED);
        this.recordsFailedForwardingCounter = pluginMetrics.counter(RECORDS_FAILED_FORWARDING);
        this.recordsMissingIdentificationKeys = pluginMetrics.counter(RECORDS_MISSING_IDENTIFICATION_KEYS);
        this.requestsFailedCounter = pluginMetrics.counter(REQUESTS_FAILED);
        this.requestsSuccessfulCounter = pluginMetrics.counter(REQUESTS_SUCCESSFUL);
    }

    @Override
    public Collection<Record<Event>> forwardRecords(Collection<Record<Event>> records) {
        Map<String, List<Record<Event>>> groupedRecords = this.groupRecordsBasedOnIdentificationKeys(records, this.identificationKeys);
        ArrayList<Record<Event>> recordsToProcessLocally = new ArrayList<Record<Event>>();
        for (Map.Entry<String, List<Record<Event>>> entry : groupedRecords.entrySet()) {
            String destinationIp = entry.getKey();
            if (this.isAddressDefinedLocally(destinationIp)) {
                recordsToProcessLocally.addAll((Collection<Record<Event>>)entry.getValue());
                this.recordsToBeProcessedLocallyCounter.increment((double)entry.getValue().size());
                continue;
            }
            this.recordsToBeForwardedCounter.increment((double)entry.getValue().size());
            List<Record<Event>> recordsFailedToBatch = this.batchRecordsForForwarding(destinationIp, entry.getValue());
            recordsToProcessLocally.addAll(recordsFailedToBatch);
        }
        this.forwardBatchedRecords();
        this.recordsActuallyProcessedLocallyCounter.increment((double)recordsToProcessLocally.size());
        return recordsToProcessLocally;
    }

    @Override
    public Collection<Record<Event>> receiveRecords() {
        Map.Entry readResult = this.peerForwarderReceiveBuffer.read(this.batchDelay);
        Collection records = (Collection)readResult.getKey();
        CheckpointState checkpointState = (CheckpointState)readResult.getValue();
        this.peerForwarderReceiveBuffer.checkpoint(checkpointState);
        return records;
    }

    private Map<String, List<Record<Event>>> groupRecordsBasedOnIdentificationKeys(Collection<Record<Event>> records, Set<String> identificationKeys) {
        HashMap<String, List<Record<Event>>> groupedRecords = new HashMap<String, List<Record<Event>>>();
        for (Record<Event> record : records) {
            Event event = (Event)record.getData();
            LinkedList<String> identificationKeyValues = new LinkedList<String>();
            int numMissingIdentificationKeys = 0;
            for (String identificationKey : identificationKeys) {
                Object identificationKeyValue = event.get(identificationKey, Object.class);
                if (identificationKeyValue == null) {
                    identificationKeyValues.add(null);
                    ++numMissingIdentificationKeys;
                    continue;
                }
                identificationKeyValues.add(identificationKeyValue.toString());
            }
            if (numMissingIdentificationKeys == identificationKeys.size()) {
                this.recordsMissingIdentificationKeys.increment(1.0);
                identificationKeyValues.clear();
            }
            String dataPrepperIp = this.hashRing.getServerIp(identificationKeyValues).orElse("127.0.0.1");
            groupedRecords.computeIfAbsent(dataPrepperIp, x -> new ArrayList()).add(record);
        }
        return groupedRecords;
    }

    private boolean isAddressDefinedLocally(String address) {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(address);
        }
        catch (UnknownHostException e) {
            return false;
        }
        if (inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress()) {
            return true;
        }
        try {
            return NetworkInterface.getByInetAddress(inetAddress) != null;
        }
        catch (SocketException e) {
            return false;
        }
    }

    private List<Record<Event>> batchRecordsForForwarding(String destinationIp, List<Record<Event>> records) {
        try {
            List<Record<Event>> recordsFailedToBatch = this.populateBatchingQueue(destinationIp, records);
            if (!recordsFailedToBatch.isEmpty()) {
                this.recordsFailedForwardingCounter.increment((double)recordsFailedToBatch.size());
            }
            return recordsFailedToBatch;
        }
        catch (Exception ex) {
            LOG.warn("Unable to batch records for forwarding, processing locally.", (Throwable)ex);
            this.recordsFailedForwardingCounter.increment((double)records.size());
            return records;
        }
    }

    private List<Record<Event>> populateBatchingQueue(String destinationIp, List<Record<Event>> records) {
        this.peerBatchingQueueMap.putIfAbsent(destinationIp, new LinkedBlockingQueue(this.forwardingBatchSize * this.pipelineWorkerThreads * this.forwardingBatchQueueDepth));
        this.peerBatchingLastFlushTimeMap.putIfAbsent(destinationIp, System.currentTimeMillis());
        ArrayList<Record<Event>> recordsFailedToBatch = new ArrayList<Record<Event>>();
        LinkedBlockingQueue<Record<Event>> peerBatchingQueue = this.peerBatchingQueueMap.get(destinationIp);
        for (Record<Event> record : records) {
            try {
                peerBatchingQueue.add(record);
            }
            catch (IllegalStateException e) {
                recordsFailedToBatch.add(record);
            }
        }
        int numberOfRecordsFailedToBatch = recordsFailedToBatch.size();
        if (numberOfRecordsFailedToBatch > 0) {
            LOG.warn("Failed to add {} records to the batching queue, processing locally.", (Object)numberOfRecordsFailedToBatch);
        }
        return recordsFailedToBatch;
    }

    private void forwardBatchedRecords() {
        HashMap<CompletableFuture, List> futuresMap = new HashMap<CompletableFuture, List>();
        this.peerBatchingQueueMap.forEach((ipAddress, records) -> futuresMap.putAll(this.forwardRecordsForIp((String)ipAddress)));
        CompletableFuture<Void> compositeFuture = CompletableFuture.allOf((CompletableFuture[])futuresMap.keySet().toArray(CompletableFuture[]::new));
        try {
            compositeFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.debug("Caught exception getting results of composite forwarding future.", (Throwable)e);
        }
        futuresMap.forEach((key, value) -> {
            AggregatedHttpResponse httpResponse;
            try {
                httpResponse = (AggregatedHttpResponse)key.get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.warn("Unable to send request to peer, processing locally.", (Throwable)e);
                httpResponse = null;
            }
            this.processFailedRequestsLocally(httpResponse, (Collection<Record<Event>>)value);
        });
    }

    private Map<CompletableFuture<AggregatedHttpResponse>, List<Record<Event>>> forwardRecordsForIp(String destinationIp) {
        HashMap<CompletableFuture<AggregatedHttpResponse>, List<Record<Event>>> forwardingRequestsMap = new HashMap<CompletableFuture<AggregatedHttpResponse>, List<Record<Event>>>();
        List<Record<Event>> recordsToForward = this.getRecordsToForward(destinationIp);
        while (!recordsToForward.isEmpty()) {
            try {
                CompletableFuture<AggregatedHttpResponse> responseFuture = this.peerForwarderClient.serializeRecordsAndSendHttpRequest(recordsToForward, destinationIp, this.pluginId, this.pipelineName);
                forwardingRequestsMap.put(responseFuture, recordsToForward);
                for (Record<Event> record : recordsToForward) {
                    Event event = (Event)record.getData();
                    event.getEventHandle().release(true);
                }
            }
            catch (Exception e) {
                LOG.warn("Unable to submit request for forwarding, processing locally.", (Throwable)e);
                this.processFailedRequestsLocally(null, recordsToForward);
            }
            recordsToForward = this.getRecordsToForward(destinationIp);
        }
        return forwardingRequestsMap;
    }

    private List<Record<Event>> getRecordsToForward(String destinationIp) {
        if (this.shouldFlushBatch(destinationIp)) {
            this.peerBatchingLastFlushTimeMap.put(destinationIp, System.currentTimeMillis());
            ArrayList<Record<Event>> recordsToForward = new ArrayList<Record<Event>>();
            this.peerBatchingQueueMap.get(destinationIp).drainTo(recordsToForward, this.forwardingBatchSize);
            return recordsToForward;
        }
        return Collections.emptyList();
    }

    private boolean shouldFlushBatch(String destinationIp) {
        long currentTime = System.currentTimeMillis();
        long millisSinceLastFlush = currentTime - this.peerBatchingLastFlushTimeMap.getOrDefault(destinationIp, System.currentTimeMillis());
        Duration durationSinceLastFlush = Duration.of(millisSinceLastFlush, ChronoUnit.MILLIS);
        boolean shouldFlushDueToTimeout = durationSinceLastFlush.compareTo(this.forwardingBatchTimeout) >= 0;
        return shouldFlushDueToTimeout || this.peerBatchingQueueMap.get(destinationIp).size() >= this.forwardingBatchSize;
    }

    void processFailedRequestsLocally(AggregatedHttpResponse httpResponse, Collection<Record<Event>> records) {
        if (httpResponse == null || httpResponse.status() != HttpStatus.OK) {
            try {
                this.peerForwarderReceiveBuffer.writeAll(records, this.failedForwardingRequestLocalWriteTimeout);
                this.recordsActuallyProcessedLocallyCounter.increment((double)records.size());
            }
            catch (Exception e) {
                LOG.error("Unable to write failed records to local peer forwarder receive buffer due to {}. Dropping {} records.", (Object)e.getMessage(), (Object)records.size());
            }
            this.recordsFailedForwardingCounter.increment((double)records.size());
            this.requestsFailedCounter.increment();
        } else {
            this.recordsSuccessfullyForwardedCounter.increment((double)records.size());
            this.requestsSuccessfulCounter.increment();
        }
    }
}

