/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.peerforwarder;

import org.opensearch.dataprepper.core.peerforwarder.HashRing;
import org.opensearch.dataprepper.core.peerforwarder.PeerClientPool;
import org.opensearch.dataprepper.core.peerforwarder.PeerForwarderConfiguration;
import org.opensearch.dataprepper.core.peerforwarder.certificate.CertificateProviderFactory;
import org.opensearch.dataprepper.core.peerforwarder.discovery.DiscoveryMode;
import org.opensearch.dataprepper.core.peerforwarder.discovery.PeerListProvider;
import org.opensearch.dataprepper.metrics.PluginMetrics;

public class PeerForwarderClientFactory {
    public static final int NUM_VIRTUAL_NODES = 128;
    private final PeerForwarderConfiguration peerForwarderConfiguration;
    private final PeerClientPool peerClientPool;
    private final CertificateProviderFactory certificateProviderFactory;
    private final PluginMetrics pluginMetrics;

    public PeerForwarderClientFactory(PeerForwarderConfiguration peerForwarderConfiguration, PeerClientPool peerClientPool, CertificateProviderFactory certificateProviderFactory, PluginMetrics pluginMetrics) {
        this.peerForwarderConfiguration = peerForwarderConfiguration;
        this.peerClientPool = peerClientPool;
        this.certificateProviderFactory = certificateProviderFactory;
        this.pluginMetrics = pluginMetrics;
    }

    public HashRing createHashRing() {
        DiscoveryMode discoveryMode = this.peerForwarderConfiguration.getDiscoveryMode();
        PeerListProvider peerListProvider = discoveryMode.create(this.peerForwarderConfiguration, this.pluginMetrics);
        return new HashRing(peerListProvider, 128);
    }

    public PeerClientPool setPeerClientPool() {
        this.peerClientPool.setClientTimeoutMillis(this.peerForwarderConfiguration.getClientTimeout());
        int targetPort = this.peerForwarderConfiguration.getServerPort();
        this.peerClientPool.setPort(targetPort);
        boolean ssl = this.peerForwarderConfiguration.isSsl();
        boolean useAcmCertForSsl = this.peerForwarderConfiguration.isUseAcmCertificateForSsl();
        this.peerClientPool.setAuthentication(this.peerForwarderConfiguration.getAuthentication());
        if (ssl || useAcmCertForSsl) {
            this.peerClientPool.setSsl(true);
            this.peerClientPool.setSslDisableVerification(this.peerForwarderConfiguration.isSslDisableVerification());
            this.peerClientPool.setSslFingerprintVerificationOnly(this.peerForwarderConfiguration.isSslFingerprintVerificationOnly());
            this.peerClientPool.setCertificate(this.certificateProviderFactory.getCertificateProvider().getCertificate());
        }
        return this.peerClientPool;
    }
}

