/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.peerforwarder;

import com.linecorp.armeria.client.ClientBuilder;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientFactoryBuilder;
import com.linecorp.armeria.client.Clients;
import com.linecorp.armeria.client.WebClient;
import io.netty.handler.ssl.util.FingerprintTrustManagerFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.TrustManagerFactory;
import org.opensearch.dataprepper.core.peerforwarder.ForwardingAuthentication;
import org.opensearch.dataprepper.plugins.certificate.model.Certificate;

public class PeerClientPool {
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private final Map<String, WebClient> peerClients = new ConcurrentHashMap<String, WebClient>();
    private int port;
    private int clientTimeoutMillis = 60000;
    private boolean ssl;
    private Certificate certificate;
    private boolean sslDisableVerification;
    private boolean sslFingerprintVerificationOnly;
    private ForwardingAuthentication authentication;

    public void setClientTimeoutMillis(int clientTimeoutMillis) {
        this.clientTimeoutMillis = clientTimeoutMillis;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setCertificate(Certificate certificate) {
        this.certificate = certificate;
    }

    public void setSslDisableVerification(boolean sslDisableVerification) {
        this.sslDisableVerification = sslDisableVerification;
    }

    public void setSslFingerprintVerificationOnly(boolean sslFingerprintVerificationOnly) {
        this.sslFingerprintVerificationOnly = sslFingerprintVerificationOnly;
    }

    public void setAuthentication(ForwardingAuthentication authentication) {
        this.authentication = authentication;
    }

    public WebClient getClient(String address) {
        return this.peerClients.computeIfAbsent(address, this::getHTTPClient);
    }

    private WebClient getHTTPClient(String ipAddress) {
        String protocol = this.ssl ? HTTPS : HTTP;
        ClientBuilder clientBuilder = Clients.builder((String)String.format("%s://%s:%s/", protocol, ipAddress, this.port)).writeTimeout(Duration.ofMillis(this.clientTimeoutMillis)).responseTimeout(Duration.ofMillis(this.clientTimeoutMillis));
        if (this.ssl) {
            ClientFactoryBuilder clientFactoryBuilder = ClientFactory.builder();
            if (this.sslFingerprintVerificationOnly) {
                FingerprintTrustManagerFactory fingerprintTrustManagerFactory = new FingerprintTrustManagerFactory(new String[]{this.certificate.getFingerprint()});
                clientFactoryBuilder.tlsCustomizer(sslContextBuilder -> sslContextBuilder.trustManager((TrustManagerFactory)fingerprintTrustManagerFactory));
            } else {
                clientFactoryBuilder.tlsCustomizer(sslContextBuilder -> sslContextBuilder.trustManager((InputStream)new ByteArrayInputStream(this.certificate.getCertificate().getBytes(StandardCharsets.UTF_8))));
            }
            if (this.sslDisableVerification) {
                clientFactoryBuilder.tlsNoVerifyHosts(new String[]{ipAddress});
            }
            if (this.authentication == ForwardingAuthentication.MUTUAL_TLS) {
                clientFactoryBuilder.tlsCustomizer(sslContextBuilder -> sslContextBuilder.keyManager((InputStream)new ByteArrayInputStream(this.certificate.getCertificate().getBytes(StandardCharsets.UTF_8)), (InputStream)new ByteArrayInputStream(this.certificate.getPrivateKey().getBytes(StandardCharsets.UTF_8))));
            }
            clientBuilder = clientBuilder.factory(clientFactoryBuilder.build());
        }
        return (WebClient)clientBuilder.build(WebClient.class);
    }
}

