/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.peerforwarder;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum ForwardingAuthentication {
    MUTUAL_TLS("mutual_tls"),
    UNAUTHENTICATED("unauthenticated");

    private static final Map<String, ForwardingAuthentication> STRING_NAME_TO_ENUM_MAP;
    private final String name;

    private ForwardingAuthentication(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    static ForwardingAuthentication getByName(String name) {
        return Optional.ofNullable(STRING_NAME_TO_ENUM_MAP.get(name)).orElseThrow(() -> new IllegalArgumentException("Unrecognized ForwardingAuthentication: " + name));
    }

    static {
        STRING_NAME_TO_ENUM_MAP = new HashMap<String, ForwardingAuthentication>();
        Arrays.stream(ForwardingAuthentication.values()).forEach(enumValue -> STRING_NAME_TO_ENUM_MAP.put(enumValue.name, (ForwardingAuthentication)((Object)enumValue)));
    }
}

