/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.parser;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.core.breaker.CircuitBreakerManager;
import org.opensearch.dataprepper.core.parser.CircuitBreakingBuffer;
import org.opensearch.dataprepper.core.parser.DataFlowComponent;
import org.opensearch.dataprepper.core.parser.MultiBufferDecorator;
import org.opensearch.dataprepper.core.parser.model.DataPrepperConfiguration;
import org.opensearch.dataprepper.core.peerforwarder.PeerForwarderConfiguration;
import org.opensearch.dataprepper.core.peerforwarder.PeerForwarderProvider;
import org.opensearch.dataprepper.core.peerforwarder.PeerForwarderReceiveBuffer;
import org.opensearch.dataprepper.core.peerforwarder.PeerForwardingProcessorDecorator;
import org.opensearch.dataprepper.core.pipeline.Pipeline;
import org.opensearch.dataprepper.core.pipeline.PipelineConnector;
import org.opensearch.dataprepper.core.pipeline.PipelineRunnerImpl;
import org.opensearch.dataprepper.core.pipeline.SupportsPipelineRunner;
import org.opensearch.dataprepper.core.pipeline.router.Router;
import org.opensearch.dataprepper.core.pipeline.router.RouterFactory;
import org.opensearch.dataprepper.core.sourcecoordination.SourceCoordinatorFactory;
import org.opensearch.dataprepper.core.validation.PluginErrorCollector;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSetManager;
import org.opensearch.dataprepper.model.annotations.SingleThread;
import org.opensearch.dataprepper.model.breaker.CircuitBreaker;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.configuration.PipelineModel;
import org.opensearch.dataprepper.model.configuration.PipelinesDataFlowModel;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.event.EventFactory;
import org.opensearch.dataprepper.model.peerforwarder.RequiresPeerForwarding;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.model.plugin.PluginFactory;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.model.sink.Sink;
import org.opensearch.dataprepper.model.sink.SinkContext;
import org.opensearch.dataprepper.model.source.Source;
import org.opensearch.dataprepper.pipeline.parser.PipelineConfigurationValidator;
import org.opensearch.dataprepper.pipeline.parser.model.PipelineConfiguration;
import org.opensearch.dataprepper.pipeline.parser.model.SinkContextPluginSetting;
import org.opensearch.dataprepper.validation.PluginError;
import org.opensearch.dataprepper.validation.PluginErrorsHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineTransformer {
    static final String CONDITIONAL_ROUTE_INVALID_EXPRESSION_FORMAT = "Route %s contains an invalid conditional expression '%s'. See https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/ for valid expression syntax.";
    private static final Logger LOG = LoggerFactory.getLogger(PipelineTransformer.class);
    private static final String PIPELINE_TYPE = "pipeline";
    private static final String ATTRIBUTE_NAME = "name";
    private final RouterFactory routerFactory;
    private final DataPrepperConfiguration dataPrepperConfiguration;
    private final CircuitBreakerManager circuitBreakerManager;
    private final Map<String, PipelineConnector> sourceConnectorMap = new HashMap<String, PipelineConnector>();
    private final PluginFactory pluginFactory;
    private final PeerForwarderProvider peerForwarderProvider;
    private final EventFactory eventFactory;
    private final AcknowledgementSetManager acknowledgementSetManager;
    private final SourceCoordinatorFactory sourceCoordinatorFactory;
    private final PluginErrorCollector pluginErrorCollector;
    private final PluginErrorsHandler pluginErrorsHandler;
    private final ExpressionEvaluator expressionEvaluator;

    public PipelineTransformer(PluginFactory pluginFactory, PeerForwarderProvider peerForwarderProvider, RouterFactory routerFactory, DataPrepperConfiguration dataPrepperConfiguration, CircuitBreakerManager circuitBreakerManager, EventFactory eventFactory, AcknowledgementSetManager acknowledgementSetManager, SourceCoordinatorFactory sourceCoordinatorFactory, PluginErrorCollector pluginErrorCollector, PluginErrorsHandler pluginErrorsHandler, ExpressionEvaluator expressionEvaluator) {
        this.pluginFactory = Objects.requireNonNull(pluginFactory);
        this.peerForwarderProvider = Objects.requireNonNull(peerForwarderProvider);
        this.routerFactory = routerFactory;
        this.dataPrepperConfiguration = Objects.requireNonNull(dataPrepperConfiguration);
        this.circuitBreakerManager = circuitBreakerManager;
        this.eventFactory = eventFactory;
        this.acknowledgementSetManager = acknowledgementSetManager;
        this.sourceCoordinatorFactory = sourceCoordinatorFactory;
        this.pluginErrorCollector = pluginErrorCollector;
        this.pluginErrorsHandler = pluginErrorsHandler;
        this.expressionEvaluator = expressionEvaluator;
    }

    public Map<String, Pipeline> transformConfiguration(PipelinesDataFlowModel pipelinesDataFlowModel) {
        Map<String, PipelineConfiguration> pipelineConfigurationMap = pipelinesDataFlowModel.getPipelines().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new PipelineConfiguration((PipelineModel)entry.getValue())));
        List allPipelineNames = PipelineConfigurationValidator.validateAndGetPipelineNames(pipelineConfigurationMap);
        LinkedHashMap<String, Pipeline> pipelineMap = new LinkedHashMap<String, Pipeline>();
        pipelineConfigurationMap.forEach((pipelineName, configuration) -> configuration.updateCommonPipelineConfiguration(pipelineName));
        for (String pipelineName2 : allPipelineNames) {
            if (pipelineMap.containsKey(pipelineName2) || !pipelineConfigurationMap.containsKey(pipelineName2)) continue;
            this.buildPipelineFromConfiguration(pipelineName2, pipelineConfigurationMap, pipelineMap);
        }
        return pipelineMap;
    }

    private void buildPipelineFromConfiguration(String pipelineName, Map<String, PipelineConfiguration> pipelineConfigurationMap, Map<String, Pipeline> pipelineMap) {
        PipelineConfiguration pipelineConfiguration = pipelineConfigurationMap.get(pipelineName);
        LOG.info("Building pipeline [{}] from provided configuration", (Object)pipelineName);
        try {
            PluginSetting sourceSetting = pipelineConfiguration.getSourcePluginSetting();
            Optional<Source> pipelineSource = this.getSourceIfPipelineType(pipelineName, sourceSetting, pipelineMap, pipelineConfigurationMap);
            Source source = pipelineSource.orElseGet(() -> {
                try {
                    return (Source)this.pluginFactory.loadPlugin(Source.class, sourceSetting, new Object[0]);
                }
                catch (Exception e) {
                    PluginError pluginError = PluginError.builder().componentType("source").pipelineName(pipelineName).pluginName(sourceSetting.getName()).exception(e).build();
                    this.pluginErrorCollector.collectPluginError(pluginError);
                    return null;
                }
            });
            LOG.info("Building buffer for the pipeline [{}]", (Object)pipelineName);
            Buffer pipelineDefinedBuffer = null;
            PluginSetting bufferPluginSetting = pipelineConfiguration.getBufferPluginSetting();
            try {
                if (source != null) {
                    pipelineDefinedBuffer = (Buffer)this.pluginFactory.loadPlugin(Buffer.class, bufferPluginSetting, new Object[]{source.getDecoder()});
                }
            }
            catch (Exception e) {
                PluginError pluginError2 = PluginError.builder().componentType("buffer").pipelineName(pipelineName).pluginName(bufferPluginSetting.getName()).exception(e).build();
                this.pluginErrorCollector.collectPluginError(pluginError2);
            }
            LOG.info("Building processors for the pipeline [{}]", (Object)pipelineName);
            int processorThreads = pipelineConfiguration.getWorkers();
            List processorSets = pipelineConfiguration.getProcessorPluginSettings().stream().map(this::newProcessor).collect(Collectors.toList());
            LOG.info("Building sinks for the pipeline [{}]", (Object)pipelineName);
            List<DataFlowComponent<Sink>> sinks = pipelineConfiguration.getSinkPluginSettings().stream().map(this::buildRoutedSinkOrConnector).collect(Collectors.toList());
            List<PluginError> invalidRouteExpressions = pipelineConfiguration.getRoutes().stream().filter(route -> this.expressionEvaluator.isValidExpressionStatement(route.getCondition()) == false).map(route -> PluginError.builder().componentType("route").pipelineName(pipelineName).exception((Exception)new InvalidPluginConfigurationException(String.format(CONDITIONAL_ROUTE_INVALID_EXPRESSION_FORMAT, route.getName(), route.getCondition()))).build()).collect(Collectors.toList());
            invalidRouteExpressions.forEach(arg_0 -> ((PluginErrorCollector)this.pluginErrorCollector).collectPluginError(arg_0));
            List subPipelinePluginErrors = this.pluginErrorCollector.getPluginErrors().stream().filter(pluginError -> pipelineName.equals(pluginError.getPipelineName())).collect(Collectors.toList());
            if (!subPipelinePluginErrors.isEmpty()) {
                this.pluginErrorsHandler.handleErrors(subPipelinePluginErrors);
                throw new InvalidPluginConfigurationException(String.format("One or more plugins are not configured correctly in the pipeline: %s.\n", pipelineName));
            }
            List<List<Processor>> decoratedProcessorSets = processorSets.stream().map(processorComponentList -> {
                List<Processor> processors = processorComponentList.stream().map(IdentifiedComponent::getComponent).collect(Collectors.toList());
                if (!processors.isEmpty() && processors.get(0) instanceof RequiresPeerForwarding) {
                    return PeerForwardingProcessorDecorator.decorateProcessors(processors, this.peerForwarderProvider, pipelineName, ((IdentifiedComponent)processorComponentList.get(0)).getName(), this.dataPrepperConfiguration.getPeerForwarderConfiguration() != null ? this.dataPrepperConfiguration.getPeerForwarderConfiguration().getExcludeIdentificationKeys() : null, pipelineConfiguration.getWorkers());
                }
                return processors;
            }).collect(Collectors.toList());
            int readBatchDelay = pipelineConfiguration.getReadBatchDelay();
            List<Buffer> secondaryBuffers = this.getSecondaryBuffers();
            LOG.info("Constructing MultiBufferDecorator with [{}] secondary buffers for pipeline [{}]", (Object)secondaryBuffers.size(), (Object)pipelineName);
            MultiBufferDecorator multiBufferDecorator = new MultiBufferDecorator(pipelineDefinedBuffer, secondaryBuffers);
            Buffer buffer = this.applyCircuitBreakerToBuffer(source, multiBufferDecorator);
            Router router = this.routerFactory.createRouter(pipelineConfiguration.getRoutes());
            Pipeline pipeline = new Pipeline(pipelineName, source, buffer, decoratedProcessorSets, sinks, router, this.eventFactory, this.acknowledgementSetManager, this.sourceCoordinatorFactory, processorThreads, readBatchDelay, this.dataPrepperConfiguration.getProcessorShutdownTimeout(), this.dataPrepperConfiguration.getSinkShutdownTimeout(), this.getPeerForwarderDrainTimeout(this.dataPrepperConfiguration));
            if (pipelineDefinedBuffer instanceof SupportsPipelineRunner) {
                boolean hasSingleThreadedProcessors = processorSets.stream().flatMap(Collection::stream).map(IdentifiedComponent::getComponent).map(Object::getClass).anyMatch(processorClass -> processorClass.isAnnotationPresent(SingleThread.class));
                if (processorThreads == 1 && !hasSingleThreadedProcessors) {
                    ((SupportsPipelineRunner)pipelineDefinedBuffer).setPipelineRunner(new PipelineRunnerImpl(pipeline));
                } else {
                    if (hasSingleThreadedProcessors) {
                        throw new IllegalStateException("ZeroBuffer cannot be used with @SingleThread processors. Pipeline [" + pipelineName + "] contains one or more @SingleThread processors.");
                    }
                    throw new IllegalStateException("ZeroBuffer cannot be used with multiple processor threads. Pipeline [" + pipelineName + "] is configured with " + processorThreads + " threads.");
                }
            }
            pipelineMap.put(pipelineName, pipeline);
        }
        catch (Exception ex) {
            LOG.error("Construction of pipeline components failed, skipping building of pipeline [{}] and its connected pipelines", (Object)pipelineName, (Object)ex);
            this.processRemoveIfRequired(pipelineName, pipelineConfigurationMap, pipelineMap);
        }
    }

    private List<IdentifiedComponent<Processor>> newProcessor(PluginSetting pluginSetting) {
        try {
            List processors = this.pluginFactory.loadPlugins(Processor.class, pluginSetting, actualClass -> actualClass.isAnnotationPresent(SingleThread.class) ? pluginSetting.getNumberOfProcessWorkers() : 1);
            return processors.stream().map(processor -> new IdentifiedComponent<Processor>((Processor)processor, pluginSetting.getName())).collect(Collectors.toList());
        }
        catch (Exception e) {
            PluginError pluginError = PluginError.builder().componentType("processor").pipelineName(pluginSetting.getPipelineName()).pluginName(pluginSetting.getName()).exception(e).build();
            this.pluginErrorCollector.collectPluginError(pluginError);
            return Collections.emptyList();
        }
    }

    private Optional<Source> getSourceIfPipelineType(String sourcePipelineName, PluginSetting pluginSetting, Map<String, Pipeline> pipelineMap, Map<String, PipelineConfiguration> pipelineConfigurationMap) {
        LOG.info("Building [{}] as source component for the pipeline [{}]", (Object)pluginSetting.getName(), (Object)sourcePipelineName);
        Optional<String> pipelineNameOptional = this.getPipelineNameIfPipelineType(pluginSetting);
        if (pipelineNameOptional.isPresent()) {
            String connectedPipeline = pipelineNameOptional.get();
            if (!this.sourceConnectorMap.containsKey(sourcePipelineName)) {
                LOG.info("Source of pipeline [{}] requires building of pipeline [{}]", (Object)sourcePipelineName, (Object)connectedPipeline);
                this.buildPipelineFromConfiguration(pipelineNameOptional.get(), pipelineConfigurationMap, pipelineMap);
            }
            if (!pipelineMap.containsKey(connectedPipeline)) {
                LOG.error("Connected Pipeline [{}] failed to build, Failing building source for [{}]", (Object)connectedPipeline, (Object)sourcePipelineName);
                throw new RuntimeException(String.format("Failed building source for %s, exiting", sourcePipelineName));
            }
            Pipeline sourcePipeline = pipelineMap.get(connectedPipeline);
            PipelineConnector pipelineConnector = this.sourceConnectorMap.get(sourcePipelineName);
            pipelineConnector.setSourcePipelineName(pipelineNameOptional.get());
            if (sourcePipeline.getSource().areAcknowledgementsEnabled() || sourcePipeline.getBuffer().areAcknowledgementsEnabled()) {
                pipelineConnector.enableAcknowledgements();
            }
            return Optional.of(pipelineConnector);
        }
        return Optional.empty();
    }

    private DataFlowComponent<Sink> buildRoutedSinkOrConnector(SinkContextPluginSetting pluginSetting) {
        try {
            Sink sink = this.buildSinkOrConnector((PluginSetting)pluginSetting, pluginSetting.getSinkContext());
            return new DataFlowComponent<Sink>(sink, pluginSetting.getSinkContext().getRoutes());
        }
        catch (Exception e) {
            PluginError pluginError = PluginError.builder().componentType("sink").pipelineName(pluginSetting.getPipelineName()).pluginName(pluginSetting.getName()).exception(e).build();
            this.pluginErrorCollector.collectPluginError(pluginError);
            return null;
        }
    }

    private Sink buildSinkOrConnector(PluginSetting pluginSetting, SinkContext sinkContext) {
        LOG.info("Building [{}] as sink component", (Object)pluginSetting.getName());
        Optional<String> pipelineNameOptional = this.getPipelineNameIfPipelineType(pluginSetting);
        if (pipelineNameOptional.isPresent()) {
            String pipelineName = pipelineNameOptional.get();
            PipelineConnector pipelineConnector = new PipelineConnector(pipelineName);
            this.sourceConnectorMap.put(pipelineName, pipelineConnector);
            return pipelineConnector;
        }
        return (Sink)this.pluginFactory.loadPlugin(Sink.class, pluginSetting, sinkContext);
    }

    private Optional<String> getPipelineNameIfPipelineType(PluginSetting pluginSetting) {
        if (PIPELINE_TYPE.equals(pluginSetting.getName()) && pluginSetting.getAttributeFromSettings(ATTRIBUTE_NAME) != null) {
            return Optional.of((String)pluginSetting.getAttributeFromSettings(ATTRIBUTE_NAME));
        }
        return Optional.empty();
    }

    private void removeConnectedPipelines(String failedPipeline, Map<String, PipelineConfiguration> pipelineConfigurationMap, Map<String, Pipeline> pipelineMap) {
        PipelineConfiguration failedPipelineConfiguration = pipelineConfigurationMap.remove(failedPipeline);
        Optional<String> sourcePipelineOptional = this.getPipelineNameIfPipelineType(failedPipelineConfiguration.getSourcePluginSetting());
        sourcePipelineOptional.ifPresent(sourcePipeline -> this.processRemoveIfRequired((String)sourcePipeline, pipelineConfigurationMap, pipelineMap));
        List sinkPluginSettings = failedPipelineConfiguration.getSinkPluginSettings();
        sinkPluginSettings.forEach(sinkPluginSetting -> this.getPipelineNameIfPipelineType((PluginSetting)sinkPluginSetting).ifPresent(sinkPipeline -> this.processRemoveIfRequired((String)sinkPipeline, pipelineConfigurationMap, pipelineMap)));
    }

    private void processRemoveIfRequired(String pipelineName, Map<String, PipelineConfiguration> pipelineConfigurationMap, Map<String, Pipeline> pipelineMap) {
        if (pipelineConfigurationMap.containsKey(pipelineName)) {
            pipelineMap.remove(pipelineName);
            this.sourceConnectorMap.remove(pipelineName);
            this.removeConnectedPipelines(pipelineName, pipelineConfigurationMap, pipelineMap);
        }
    }

    Duration getPeerForwarderDrainTimeout(DataPrepperConfiguration dataPrepperConfiguration) {
        return Optional.ofNullable(dataPrepperConfiguration).map(DataPrepperConfiguration::getPeerForwarderConfiguration).map(PeerForwarderConfiguration::getDrainTimeout).orElse(Duration.ofSeconds(0L));
    }

    List<Buffer> getSecondaryBuffers() {
        return this.peerForwarderProvider.getPipelinePeerForwarderReceiveBufferMap().entrySet().stream().flatMap(entry -> ((Map)entry.getValue()).entrySet().stream()).map(innerEntry -> (PeerForwarderReceiveBuffer)((Object)((Object)innerEntry.getValue()))).collect(Collectors.toList());
    }

    private Buffer applyCircuitBreakerToBuffer(Source source, Buffer buffer) {
        if (source instanceof PipelineConnector) {
            return buffer;
        }
        if (buffer.isWrittenOffHeapOnly()) {
            return buffer;
        }
        return this.circuitBreakerManager.getGlobalCircuitBreaker().map(circuitBreaker -> new CircuitBreakingBuffer(buffer, (CircuitBreaker)circuitBreaker)).map(b -> b).orElseGet(() -> buffer);
    }

    private static class IdentifiedComponent<T> {
        private final T component;
        private final String name;

        private IdentifiedComponent(T component, String name) {
            this.component = component;
            this.name = name;
        }

        T getComponent() {
            return this.component;
        }

        String getName() {
            return this.name;
        }
    }
}

