/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.meter;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;

public class JvmMemoryAggregateMetrics
implements MeterBinder {
    static final String AREA_TAG_NAME = "area";
    static final String JVM_MEMORY_USED = "jvm.memory.used";
    private final MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();

    public void bindTo(MeterRegistry registry) {
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        Gauge.builder((String)JVM_MEMORY_USED, (Object)memoryMXBean, mem -> mem.getHeapMemoryUsage().getUsed()).tags((Iterable)Tags.of((Tag[])new Tag[]{Tag.of((String)AREA_TAG_NAME, (String)"heap")})).description("The amount of used heap memory").baseUnit("bytes").register(registry);
        Gauge.builder((String)JVM_MEMORY_USED, (Object)memoryMXBean, mem -> mem.getNonHeapMemoryUsage().getUsed()).tags((Iterable)Tags.of((Tag[])new Tag[]{Tag.of((String)AREA_TAG_NAME, (String)"nonheap")})).description("The amount of used non-heap memory").baseUnit("bytes").register(registry);
    }
}

