/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper;

import org.opensearch.dataprepper.DataPrepperShutdownListener;
import org.opensearch.dataprepper.core.DataPrepper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public abstract class AbstractContextManager {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractContextManager.class);
    private static final String BASE_DATA_PREPPER_PACKAGE = "org.opensearch.dataprepper";
    private static final String[] BASE_DATA_PREPPER_PACKAGES = new String[]{"org.opensearch.dataprepper.core", "org.opensearch.dataprepper.plugin"};
    private static final String EXPRESSION_PACKAGE = "org.opensearch.dataprepper.expression";
    private final AnnotationConfigApplicationContext publicApplicationContext = new AnnotationConfigApplicationContext();
    private final AnnotationConfigApplicationContext coreApplicationContext = new AnnotationConfigApplicationContext();
    private DataPrepper dataPrepper;

    protected AbstractContextManager() {
    }

    public DataPrepper getDataPrepperBean() {
        if (this.dataPrepper == null) {
            this.start();
        }
        return this.dataPrepper;
    }

    private void start() {
        this.publicApplicationContext.scan(new String[]{EXPRESSION_PACKAGE});
        this.preRefreshPublicApplicationContext(this.publicApplicationContext);
        this.publicApplicationContext.refresh();
        this.coreApplicationContext.setParent((ApplicationContext)this.publicApplicationContext);
        this.coreApplicationContext.scan(BASE_DATA_PREPPER_PACKAGES);
        this.preRefreshCoreApplicationContext(this.coreApplicationContext);
        this.coreApplicationContext.refresh();
        this.dataPrepper = (DataPrepper)this.coreApplicationContext.getBean(DataPrepper.class);
        this.dataPrepper.registerShutdownHandler(new ContextShutdownListener());
        LOG.trace("Data Prepper context is fully refreshed.");
    }

    protected void preRefreshPublicApplicationContext(AnnotationConfigApplicationContext publicApplicationContext) {
    }

    protected void preRefreshCoreApplicationContext(AnnotationConfigApplicationContext coreApplicationContext) {
    }

    public void shutdown() {
        this.coreApplicationContext.close();
        this.publicApplicationContext.close();
    }

    private class ContextShutdownListener
    implements DataPrepperShutdownListener {
        private ContextShutdownListener() {
        }

        @Override
        public void handleShutdown() {
            AbstractContextManager.this.shutdown();
        }
    }
}

