/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.aggregate.actions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum RateLimiterMode {
    DROP("drop"),
    BLOCK("block");

    private static final Map<String, RateLimiterMode> ACTIONS_MAP;
    private final String name;

    private RateLimiterMode(String name) {
        this.name = name.toLowerCase();
    }

    public String toString() {
        return this.name;
    }

    @JsonCreator
    static RateLimiterMode fromOptionValue(String option) {
        return ACTIONS_MAP.get(option.toLowerCase());
    }

    @JsonValue
    public String getOptionValue() {
        return this.name;
    }

    static {
        ACTIONS_MAP = Arrays.stream(RateLimiterMode.values()).collect(Collectors.toMap(value -> value.name, value -> value));
    }
}

