/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.aggregate.actions;

import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateAction;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateActionInput;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateActionResponse;
import org.opensearch.dataprepper.plugins.processor.aggregate.GroupState;
import org.opensearch.dataprepper.plugins.processor.aggregate.actions.PercentSamplerAggregateActionConfig;

@DataPrepperPlugin(name="percent_sampler", pluginType=AggregateAction.class, pluginConfigurationType=PercentSamplerAggregateActionConfig.class)
public class PercentSamplerAggregateAction
implements AggregateAction {
    static final String TOTAL_EVENTS_KEY = "total_events";
    static final String TOTAL_ALLOWED_EVENTS_KEY = "total_allowed_events";
    private final double percent;

    @DataPrepperPluginConstructor
    public PercentSamplerAggregateAction(PercentSamplerAggregateActionConfig percentSamplerAggregateActionConfig) {
        this.percent = percentSamplerAggregateActionConfig.getPercent();
    }

    @Override
    public AggregateActionResponse handleEvent(Event event, AggregateActionInput aggregateActionInput) {
        GroupState groupState = aggregateActionInput.getGroupState();
        Long totalEvents = 0L;
        Long totalAllowedEvents = 0L;
        if (groupState.get(TOTAL_EVENTS_KEY) == null) {
            groupState.put(TOTAL_ALLOWED_EVENTS_KEY, 0L);
        } else {
            totalEvents = (Long)groupState.get(TOTAL_EVENTS_KEY);
            totalAllowedEvents = (Long)groupState.get(TOTAL_ALLOWED_EVENTS_KEY);
        }
        groupState.put(TOTAL_EVENTS_KEY, totalEvents + 1L);
        if ((double)(totalAllowedEvents + 1L) / (double)(totalEvents + 1L) <= this.percent / 100.0) {
            groupState.put(TOTAL_ALLOWED_EVENTS_KEY, totalAllowedEvents + 1L);
            return new AggregateActionResponse(event);
        }
        return AggregateActionResponse.nullEventResponse();
    }
}

