/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.aggregate;

import io.micrometer.core.instrument.Counter;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.peerforwarder.RequiresPeerForwarding;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.model.plugin.PluginFactory;
import org.opensearch.dataprepper.model.processor.AbstractProcessor;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.hasher.IdentificationKeysHasher;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateAction;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateActionOutput;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateActionResponse;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateActionSynchronizer;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateGroup;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateGroupManager;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateProcessorConfig;

@DataPrepperPlugin(name="aggregate", pluginType=Processor.class, pluginConfigurationType=AggregateProcessorConfig.class)
public class AggregateProcessor
extends AbstractProcessor<Record<Event>, Record<Event>>
implements RequiresPeerForwarding {
    static final String ACTION_HANDLE_EVENTS_OUT = "actionHandleEventsOut";
    static final String ACTION_HANDLE_EVENTS_DROPPED = "actionHandleEventsDropped";
    static final String ACTION_CONCLUDE_GROUP_EVENTS_OUT = "actionConcludeGroupEventsOut";
    static final String ACTION_CONCLUDE_GROUP_EVENTS_DROPPED = "actionConcludeGroupEventsDropped";
    static final String CURRENT_AGGREGATE_GROUPS = "currentAggregateGroups";
    private final Counter actionHandleEventsOutCounter;
    private final Counter actionHandleEventsDroppedCounter;
    private final Counter actionConcludeGroupEventsDroppedCounter;
    private final Counter actionConcludeGroupEventsOutCounter;
    private final AggregateProcessorConfig aggregateProcessorConfig;
    private final AggregateGroupManager aggregateGroupManager;
    private final AggregateActionSynchronizer aggregateActionSynchronizer;
    private final IdentificationKeysHasher identificationKeysHasher;
    private final AggregateAction aggregateAction;
    private boolean forceConclude = false;
    private boolean localMode = false;
    private final String whenCondition;
    private final ExpressionEvaluator expressionEvaluator;
    private final boolean outputUnaggregatedEvents;
    private final String aggregatedEventsTag;

    @DataPrepperPluginConstructor
    public AggregateProcessor(AggregateProcessorConfig aggregateProcessorConfig, PluginMetrics pluginMetrics, PluginFactory pluginFactory, ExpressionEvaluator expressionEvaluator) {
        this(aggregateProcessorConfig, pluginMetrics, pluginFactory, new AggregateGroupManager(aggregateProcessorConfig.getGroupDuration()), new IdentificationKeysHasher(aggregateProcessorConfig.getIdentificationKeys()), new AggregateActionSynchronizer.AggregateActionSynchronizerProvider(), expressionEvaluator);
    }

    public AggregateProcessor(AggregateProcessorConfig aggregateProcessorConfig, PluginMetrics pluginMetrics, PluginFactory pluginFactory, AggregateGroupManager aggregateGroupManager, IdentificationKeysHasher identificationKeysHasher, AggregateActionSynchronizer.AggregateActionSynchronizerProvider aggregateActionSynchronizerProvider, ExpressionEvaluator expressionEvaluator) {
        super(pluginMetrics);
        this.aggregateProcessorConfig = aggregateProcessorConfig;
        this.aggregatedEventsTag = aggregateProcessorConfig.getAggregatedEventsTag();
        this.aggregateGroupManager = aggregateGroupManager;
        this.outputUnaggregatedEvents = aggregateProcessorConfig.getOutputUnaggregatedEvents();
        this.expressionEvaluator = expressionEvaluator;
        this.identificationKeysHasher = identificationKeysHasher;
        this.aggregateAction = this.loadAggregateAction(pluginFactory);
        this.aggregateActionSynchronizer = aggregateActionSynchronizerProvider.provide(this.aggregateAction, aggregateGroupManager, pluginMetrics);
        this.actionConcludeGroupEventsOutCounter = pluginMetrics.counter(ACTION_CONCLUDE_GROUP_EVENTS_OUT);
        this.actionConcludeGroupEventsDroppedCounter = pluginMetrics.counter(ACTION_CONCLUDE_GROUP_EVENTS_DROPPED);
        this.actionHandleEventsOutCounter = pluginMetrics.counter(ACTION_HANDLE_EVENTS_OUT);
        this.actionHandleEventsDroppedCounter = pluginMetrics.counter(ACTION_HANDLE_EVENTS_DROPPED);
        this.whenCondition = aggregateProcessorConfig.getWhenCondition();
        this.localMode = aggregateProcessorConfig.getLocalMode();
        pluginMetrics.gauge(CURRENT_AGGREGATE_GROUPS, (Object)aggregateGroupManager, AggregateGroupManager::getAllGroupsSize);
        if (aggregateProcessorConfig.getWhenCondition() != null && !expressionEvaluator.isValidExpressionStatement(aggregateProcessorConfig.getWhenCondition()).booleanValue()) {
            throw new InvalidPluginConfigurationException(String.format("aggregate_when \"%s\" is not a valid expression statement. See https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/ for valid expression syntax", aggregateProcessorConfig.getWhenCondition()));
        }
    }

    private AggregateAction loadAggregateAction(PluginFactory pluginFactory) {
        PluginModel actionConfiguration = this.aggregateProcessorConfig.getAggregateAction();
        PluginSetting actionPluginSetting = new PluginSetting(actionConfiguration.getPluginName(), actionConfiguration.getPluginSettings());
        return (AggregateAction)pluginFactory.loadPlugin(AggregateAction.class, actionPluginSetting, new Object[0]);
    }

    AggregateGroup getAggregateGroupForEvent(IdentificationKeysHasher.IdentificationKeysMap identificationKeysMap, Event event) {
        AggregateGroup aggregateGroup = this.aggregateGroupManager.getAggregateGroup(identificationKeysMap);
        aggregateGroup.attachToEventAcknowledgementSet(event);
        return aggregateGroup;
    }

    public Collection<Record<Event>> doExecute(Collection<Record<Event>> records) {
        LinkedList<Record<Event>> recordsOut = new LinkedList<Record<Event>>();
        List<Map.Entry<IdentificationKeysHasher.IdentificationKeysMap, AggregateGroup>> groupsToConclude = this.aggregateGroupManager.getGroupsToConclude(this.forceConclude);
        for (Map.Entry<IdentificationKeysHasher.IdentificationKeysMap, AggregateGroup> groupEntry : groupsToConclude) {
            List<Event> concludeGroupEvents;
            AggregateActionOutput actionOutput = this.aggregateActionSynchronizer.concludeGroup(groupEntry.getKey(), groupEntry.getValue(), this.forceConclude);
            List<Event> list = concludeGroupEvents = actionOutput != null ? actionOutput.getEvents() : null;
            if (!concludeGroupEvents.isEmpty()) {
                concludeGroupEvents.stream().forEach(event -> {
                    if (this.aggregatedEventsTag != null) {
                        event.getMetadata().addTags(List.of(this.aggregatedEventsTag));
                    }
                    recordsOut.add(new Record(event));
                    this.actionConcludeGroupEventsOutCounter.increment();
                });
                continue;
            }
            this.actionConcludeGroupEventsDroppedCounter.increment();
        }
        int handleEventsOut = 0;
        int handleEventsDropped = 0;
        for (Record<Event> record : records) {
            AggregateGroup aggregateGroupForEvent;
            Event event2 = (Event)record.getData();
            if (this.whenCondition != null && !this.expressionEvaluator.evaluateConditional(this.whenCondition, event2).booleanValue()) {
                ++handleEventsDropped;
                continue;
            }
            IdentificationKeysHasher.IdentificationKeysMap identificationKeysMap = this.identificationKeysHasher.createIdentificationKeysMapFromEvent(event2);
            AggregateActionResponse handleEventResponse = this.aggregateActionSynchronizer.handleEventForGroup(event2, identificationKeysMap, aggregateGroupForEvent = this.getAggregateGroupForEvent(identificationKeysMap, event2));
            Event aggregateActionResponseEvent = handleEventResponse.getEvent();
            if (aggregateActionResponseEvent != null) {
                if (this.aggregatedEventsTag != null) {
                    aggregateActionResponseEvent.getMetadata().addTags(List.of(this.aggregatedEventsTag));
                }
                recordsOut.add((Record<Event>)new Record((Object)aggregateActionResponseEvent, record.getMetadata()));
                ++handleEventsOut;
            } else {
                ++handleEventsDropped;
            }
            if (!this.outputUnaggregatedEvents) continue;
            recordsOut.add(record);
        }
        this.actionHandleEventsOutCounter.increment((double)handleEventsOut);
        this.actionHandleEventsDroppedCounter.increment((double)handleEventsDropped);
        return recordsOut;
    }

    public boolean holdsEvents() {
        return this.aggregateAction.holdsEvents();
    }

    public static long getTimeNanos(Instant time) {
        long NANO_MULTIPLIER = 1000000000L;
        long currentTimeNanos = time.getEpochSecond() * 1000000000L + (long)time.getNano();
        return currentTimeNanos;
    }

    public static Instant convertObjectToInstant(Object timeObject) {
        if (timeObject instanceof Instant) {
            return (Instant)timeObject;
        }
        if (timeObject instanceof String) {
            return Instant.parse((String)timeObject);
        }
        if (timeObject instanceof Integer || timeObject instanceof Long) {
            long value = ((Number)timeObject).longValue();
            return (double)value > 1.0E10 ? Instant.ofEpochMilli(value) : Instant.ofEpochSecond(value);
        }
        if (timeObject instanceof Double || timeObject instanceof Float || timeObject instanceof BigDecimal) {
            double value = ((Number)timeObject).doubleValue();
            long seconds = (long)value;
            long nanos = (long)((value - (double)seconds) * 1.0E9);
            return Instant.ofEpochSecond(seconds, nanos);
        }
        throw new RuntimeException("Invalid format for time " + String.valueOf(timeObject));
    }

    public void prepareForShutdown() {
        this.forceConclude = true;
    }

    public boolean isReadyForShutdown() {
        return this.aggregateGroupManager.getAllGroupsSize() == 0L;
    }

    public void shutdown() {
    }

    public boolean isForLocalProcessingOnly(Event event) {
        return this.localMode;
    }

    public boolean isApplicableEventForPeerForwarding(Event event) {
        if (this.localMode) {
            return false;
        }
        if (this.whenCondition == null) {
            return true;
        }
        return this.expressionEvaluator.evaluateConditional(this.whenCondition, event);
    }

    public Collection<String> getIdentificationKeys() {
        return this.aggregateProcessorConfig.getIdentificationKeys();
    }
}

