/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.logging;

import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.server.logging.AccessLogComponent;
import com.linecorp.armeria.server.logging.AccessLogType;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

final class AccessLogFormats {
    private static final AccessLogComponent BLANK = AccessLogComponent.ofText(" ");
    static final List<AccessLogComponent> COMMON = ImmutableList.of(AccessLogComponent.ofPredefinedCommon(AccessLogType.REMOTE_HOST), BLANK, AccessLogComponent.ofPredefinedCommon(AccessLogType.RFC931), BLANK, AccessLogComponent.ofPredefinedCommon(AccessLogType.AUTHENTICATED_USER), BLANK, AccessLogComponent.ofDefaultRequestTimestamp(), BLANK, AccessLogComponent.ofPredefinedCommon(AccessLogType.REQUEST_LINE), BLANK, AccessLogComponent.ofPredefinedCommon(AccessLogType.RESPONSE_STATUS_CODE), BLANK, new AccessLogComponent[]{AccessLogComponent.ofPredefinedCommon(AccessLogType.RESPONSE_LENGTH)});
    static final List<AccessLogComponent> COMBINED = ImmutableList.of(AccessLogComponent.ofPredefinedCommon(AccessLogType.REMOTE_HOST), BLANK, AccessLogComponent.ofPredefinedCommon(AccessLogType.RFC931), BLANK, AccessLogComponent.ofPredefinedCommon(AccessLogType.AUTHENTICATED_USER), BLANK, AccessLogComponent.ofDefaultRequestTimestamp(), BLANK, AccessLogComponent.ofPredefinedCommon(AccessLogType.REQUEST_LINE), BLANK, AccessLogComponent.ofPredefinedCommon(AccessLogType.RESPONSE_STATUS_CODE), BLANK, new AccessLogComponent[]{AccessLogComponent.ofPredefinedCommon(AccessLogType.RESPONSE_LENGTH), BLANK, AccessLogComponent.ofQuotedRequestHeader((CharSequence)HttpHeaderNames.REFERER), BLANK, AccessLogComponent.ofQuotedRequestHeader((CharSequence)HttpHeaderNames.USER_AGENT), BLANK, AccessLogComponent.ofQuotedRequestHeader((CharSequence)HttpHeaderNames.COOKIE)});

    static List<AccessLogComponent> parseCustom(String formatStr) {
        Objects.requireNonNull(formatStr, "formatStr");
        ImmutableList.Builder builder = ImmutableList.builder();
        StringBuilder textBuilder = new StringBuilder();
        Condition.Builder condBuilder = null;
        String variable = null;
        State state = State.TEXT;
        int i = 0;
        block7: while (i < formatStr.length()) {
            char ch = formatStr.charAt(i);
            switch (state.ordinal()) {
                case 0: {
                    if (ch == '%') {
                        if (textBuilder.length() > 0) {
                            builder.add(AccessLogComponent.ofText(AccessLogFormats.newStringAndReset(textBuilder)));
                        }
                        condBuilder = null;
                        variable = null;
                        state = State.PERCENT;
                        break;
                    }
                    textBuilder.append(ch);
                    break;
                }
                case 1: {
                    if (Character.isAlphabetic(ch)) {
                        state = State.TOKEN;
                        continue block7;
                    }
                    if (Character.isDigit(ch)) {
                        condBuilder = Condition.builder();
                        state = State.CONDITION;
                        continue block7;
                    }
                    if (ch == '!') {
                        condBuilder = Condition.builder().setSign(false);
                        state = State.CONDITION;
                        break;
                    }
                    if (ch != '{') break;
                    state = State.VARIABLE;
                    break;
                }
                case 2: {
                    if (Character.isDigit(ch)) {
                        textBuilder.append(ch);
                        break;
                    }
                    if (textBuilder.length() > 0) {
                        condBuilder.addHttpStatus(AccessLogFormats.newStringAndReset(textBuilder));
                    }
                    if (Character.isAlphabetic(ch)) {
                        state = State.TOKEN;
                        continue block7;
                    }
                    if (ch == '{') {
                        state = State.VARIABLE;
                        break;
                    }
                    if (ch == ',') break;
                    throw new IllegalArgumentException("Unexpected character in condition:" + ch);
                }
                case 3: {
                    if (ch != '}') {
                        textBuilder.append(ch);
                        break;
                    }
                    if (textBuilder.length() > 0) {
                        variable = AccessLogFormats.newStringAndReset(textBuilder);
                    }
                    state = State.TOKEN;
                    break;
                }
                case 4: {
                    builder.add(AccessLogFormats.newAccessLogComponent(ch, variable, condBuilder));
                    state = State.TEXT;
                }
            }
            ++i;
        }
        if (state != State.TEXT) {
            throw new IllegalArgumentException("Unexpected access log format: " + formatStr);
        }
        if (textBuilder.length() > 0) {
            builder.add(AccessLogComponent.ofText(AccessLogFormats.newStringAndReset(textBuilder)));
        }
        return builder.build();
    }

    private static AccessLogComponent newAccessLogComponent(char token, @Nullable String variable, @Nullable Condition.Builder condBuilder) {
        Function<ResponseHeaders, Boolean> condition;
        AccessLogType type = AccessLogType.find(token);
        Preconditions.checkArgument(type != null, "Unexpected token character: '%s'", token);
        if (type.variableRequirement() == AccessLogType.VariableRequirement.YES) {
            Preconditions.checkArgument(variable != null, "Token %s requires a variable.", type.token());
        }
        if (type.isConditionAvailable()) {
            if (condBuilder != null) {
                Preconditions.checkArgument(!condBuilder.isEmpty(), "Token %s has an invalid condition.", type.token());
            }
        } else {
            Preconditions.checkArgument(condBuilder == null, "Token %s does not support a condition.", type.token());
        }
        if (AccessLogComponent.TextComponent.isSupported(type)) {
            assert (variable != null);
            return AccessLogComponent.ofText(variable);
        }
        boolean addQuote = false;
        Function<ResponseHeaders, Boolean> function = condition = condBuilder != null ? condBuilder.build() : null;
        if (AccessLogComponent.TimestampComponent.isSupported(type)) {
            return new AccessLogComponent.TimestampComponent(false, variable);
        }
        if (AccessLogComponent.CommonComponent.isSupported(type)) {
            return new AccessLogComponent.CommonComponent(type, false, condition, variable);
        }
        if (AccessLogComponent.HttpHeaderComponent.isSupported(type)) {
            assert (variable != null);
            return new AccessLogComponent.HttpHeaderComponent(type, (CharSequence)HttpHeaderNames.of(variable), false, condition);
        }
        if (AccessLogComponent.AttributeComponent.isSupported(type)) {
            assert (variable != null);
            String[] components = variable.split(":");
            Function<Object, String> stringifier = components.length == 2 ? AccessLogFormats.newStringifier(components[0], components[1]) : Object::toString;
            return new AccessLogComponent.AttributeComponent(components[0], stringifier, false, condition);
        }
        if (AccessLogComponent.RequestLogComponent.isSupported(type)) {
            assert (variable != null);
            return new AccessLogComponent.RequestLogComponent(variable, false, condition);
        }
        throw new Error("Unexpected access log type: " + type.name());
    }

    private static String newStringAndReset(StringBuilder textBuilder) {
        String str = textBuilder.toString();
        textBuilder.setLength(0);
        return str;
    }

    private static Function<Object, String> newStringifier(String attrName, String className) {
        Function stringifier;
        try {
            stringifier = (Function)Class.forName(className, true, AccessLogFormats.class.getClassLoader()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to instantiate a stringifier function: " + attrName, e);
        }
        return stringifier;
    }

    private AccessLogFormats() {
    }

    private static enum State {
        TEXT,
        PERCENT,
        CONDITION,
        VARIABLE,
        TOKEN;

    }

    private static final class Condition
    implements Function<ResponseHeaders, Boolean> {
        private final Set<HttpStatus> statusSet;
        private final boolean sign;

        Condition(Set<HttpStatus> statusSet, boolean sign) {
            this.statusSet = statusSet;
            this.sign = sign;
        }

        public Set<HttpStatus> statusSet() {
            return this.statusSet;
        }

        public boolean isSign() {
            return this.sign;
        }

        @Override
        public Boolean apply(ResponseHeaders headers) {
            return this.statusSet.contains(headers.status()) == this.sign;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("sign", this.isSign()).add("statusSet", this.statusSet()).toString();
        }

        static Builder builder() {
            return new Builder();
        }

        static final class Builder {
            private final ImmutableSet.Builder<HttpStatus> statusSet = ImmutableSet.builder();
            private boolean sign = true;
            private boolean isEmpty = true;

            Builder() {
            }

            Builder setSign(boolean sign) {
                this.sign = sign;
                return this;
            }

            Builder addHttpStatus(String text) {
                HttpStatus s = HttpStatus.valueOf(Integer.parseInt(text));
                this.statusSet.add((Object)s);
                this.isEmpty = false;
                return this;
            }

            boolean isEmpty() {
                return this.isEmpty;
            }

            Function<ResponseHeaders, Boolean> build() {
                return new Condition((Set<HttpStatus>)((Object)this.statusSet.build()), this.sign);
            }
        }
    }
}

