/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.server.annotation;

import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.ExchangeType;
import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ResponseEntity;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.ResponseHeadersBuilder;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.BlockingTaskExecutor;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.common.util.UnmodifiableFuture;
import com.linecorp.armeria.internal.server.FileAggregatedMultipart;
import com.linecorp.armeria.internal.server.annotation.AnnotatedValueResolver;
import com.linecorp.armeria.internal.server.annotation.AnnotationUtil;
import com.linecorp.armeria.internal.server.annotation.ClassUtil;
import com.linecorp.armeria.internal.server.annotation.HttpResultUtil;
import com.linecorp.armeria.internal.server.annotation.KotlinUtil;
import com.linecorp.armeria.internal.server.annotation.ResponseConverterFunctionUtil;
import com.linecorp.armeria.internal.server.annotation.ResponseEntityUtil;
import com.linecorp.armeria.internal.server.annotation.ScalaUtil;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceOption;
import com.linecorp.armeria.server.ServiceOptions;
import com.linecorp.armeria.server.ServiceOptionsBuilder;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.SimpleDecoratingHttpService;
import com.linecorp.armeria.server.annotation.AnnotatedService;
import com.linecorp.armeria.server.annotation.ExceptionHandlerFunction;
import com.linecorp.armeria.server.annotation.ExceptionVerbosity;
import com.linecorp.armeria.server.annotation.FallthroughException;
import com.linecorp.armeria.server.annotation.HttpResult;
import com.linecorp.armeria.server.annotation.ResponseConverterFunction;
import com.linecorp.armeria.server.annotation.ServiceName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.Future;

final class DefaultAnnotatedService
implements AnnotatedService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAnnotatedService.class);
    private static final MethodHandles.Lookup lookup = MethodHandles.lookup();
    private static final CompletableFuture<AnnotatedValueResolver.AggregatedResult> NO_AGGREGATION_FUTURE = UnmodifiableFuture.completedFuture(AnnotatedValueResolver.AggregatedResult.EMPTY);
    private final Object object;
    private final Class<?> serviceClass;
    private final Method method;
    private final int overloadId;
    private final MethodHandle methodHandle;
    @Nullable
    private final MethodHandle callKotlinSuspendingMethod;
    private final boolean isKotlinSuspendingMethod;
    private final List<AnnotatedValueResolver> resolvers;
    private final AnnotatedValueResolver.AggregationStrategy aggregationStrategy;
    @Nullable
    private final ExceptionHandlerFunction exceptionHandler;
    private final ResponseConverterFunction responseConverter;
    private final Type actualReturnType;
    private final Route route;
    private final HttpStatus defaultStatus;
    private final HttpHeaders defaultHttpHeaders;
    private final HttpHeaders defaultHttpTrailers;
    private final ResponseType responseType;
    private final boolean useBlockingTaskExecutor;
    @Nullable
    private final String name;
    private final ServiceOptions options;

    DefaultAnnotatedService(Object object, Method method, int overloadId, List<AnnotatedValueResolver> resolvers, List<ExceptionHandlerFunction> exceptionHandlers, List<ResponseConverterFunction> responseConverters, Route route, HttpStatus defaultStatus, HttpHeaders defaultHttpHeaders, HttpHeaders defaultHttpTrailers, boolean useBlockingTaskExecutor) {
        this.object = Objects.requireNonNull(object, "object");
        this.method = Objects.requireNonNull(method, "method");
        Preconditions.checkArgument(overloadId >= 0, "overloadId: %s (expected: >= 0)", overloadId);
        this.overloadId = overloadId;
        this.serviceClass = ClassUtil.getUserClass(object.getClass());
        Preconditions.checkArgument(!method.isVarArgs(), "%s#%s declared to take a variable number of arguments", (Object)method.getDeclaringClass().getSimpleName(), (Object)method.getName());
        this.isKotlinSuspendingMethod = KotlinUtil.isSuspendingFunction(method);
        this.resolvers = Objects.requireNonNull(resolvers, "resolvers");
        Objects.requireNonNull(exceptionHandlers, "exceptionHandlers");
        this.exceptionHandler = exceptionHandlers.isEmpty() ? null : new CompositeExceptionHandlerFunction(object.getClass().getSimpleName(), method.getName(), exceptionHandlers);
        this.actualReturnType = DefaultAnnotatedService.getActualReturnType(method);
        this.responseConverter = ResponseConverterFunctionUtil.newResponseConverter(this.actualReturnType, Objects.requireNonNull(responseConverters, "responseConverters"));
        this.aggregationStrategy = AnnotatedValueResolver.AggregationStrategy.from(resolvers);
        this.route = Objects.requireNonNull(route, "route");
        this.defaultStatus = Objects.requireNonNull(defaultStatus, "defaultStatus");
        this.defaultHttpHeaders = Objects.requireNonNull(defaultHttpHeaders, "defaultHttpHeaders");
        this.defaultHttpTrailers = Objects.requireNonNull(defaultHttpTrailers, "defaultHttpTrailers");
        this.useBlockingTaskExecutor = useBlockingTaskExecutor;
        Class<?> returnType = method.getReturnType();
        this.responseType = HttpResponse.class.isAssignableFrom(returnType) ? ResponseType.HTTP_RESPONSE : (CompletionStage.class.isAssignableFrom(returnType) ? ResponseType.COMPLETION_STAGE : (this.isKotlinSuspendingMethod ? ResponseType.KOTLIN_COROUTINES : (ScalaUtil.isScalaFuture(returnType) ? ResponseType.SCALA_FUTURE : ResponseType.OTHER_OBJECTS)));
        this.callKotlinSuspendingMethod = KotlinUtil.getCallKotlinSuspendingMethod();
        ServiceName serviceName = AnnotationUtil.findFirst(method, ServiceName.class);
        if (serviceName == null) {
            serviceName = AnnotationUtil.findFirst(object.getClass(), ServiceName.class);
        }
        this.name = serviceName != null ? serviceName.value() : null;
        this.method.setAccessible(true);
        this.methodHandle = DefaultAnnotatedService.asMethodHandle(method, object);
        ServiceOption serviceOption = AnnotationUtil.findFirst(method, ServiceOption.class);
        if (serviceOption == null) {
            serviceOption = AnnotationUtil.findFirst(object.getClass(), ServiceOption.class);
        }
        this.options = serviceOption != null ? DefaultAnnotatedService.buildServiceOptions(serviceOption) : ServiceOptions.of();
    }

    private static Type getActualReturnType(Method method) {
        Type genericReturnType;
        Class<?> returnType;
        if (KotlinUtil.isKFunction(method)) {
            returnType = KotlinUtil.kFunctionReturnType(method);
            genericReturnType = KotlinUtil.isReturnTypeNothing(method) ? KotlinUtil.kFunctionReturnType(method) : KotlinUtil.kFunctionGenericReturnType(method);
        } else {
            returnType = method.getReturnType();
            genericReturnType = method.getGenericReturnType();
        }
        if (HttpResult.class.isAssignableFrom(returnType) || ResponseEntity.class.isAssignableFrom(returnType)) {
            ParameterizedType type = (ParameterizedType)genericReturnType;
            DefaultAnnotatedService.warnIfHttpResponseArgumentExists(type, type, returnType);
            return type.getActualTypeArguments()[0];
        }
        return genericReturnType;
    }

    private static void warnIfHttpResponseArgumentExists(Type returnType, ParameterizedType type, Class<?> originalReturnType) {
        for (Type arg : type.getActualTypeArguments()) {
            Class clazz;
            if (arg instanceof ParameterizedType) {
                DefaultAnnotatedService.warnIfHttpResponseArgumentExists(returnType, (ParameterizedType)arg, originalReturnType);
                continue;
            }
            if (!(arg instanceof Class) || !HttpResponse.class.isAssignableFrom(clazz = (Class)arg) && !AggregatedHttpResponse.class.isAssignableFrom(clazz)) continue;
            logger.warn("{} in the return type '{}' may take precedence over {}.", new Object[]{clazz.getSimpleName(), returnType, originalReturnType.getSimpleName()});
        }
    }

    private static ServiceOptions buildServiceOptions(ServiceOption serviceOption) {
        ServiceOptionsBuilder builder = ServiceOptions.builder();
        if (serviceOption.requestTimeoutMillis() >= 0L) {
            builder.requestTimeoutMillis(serviceOption.requestTimeoutMillis());
        }
        if (serviceOption.maxRequestLength() >= 0L) {
            builder.maxRequestLength(serviceOption.maxRequestLength());
        }
        if (serviceOption.requestAutoAbortDelayMillis() >= 0L) {
            builder.requestAutoAbortDelayMillis(serviceOption.requestAutoAbortDelayMillis());
        }
        return builder.build();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Object serviceObject() {
        return this.object;
    }

    @Override
    public Class<?> serviceClass() {
        return this.serviceClass;
    }

    @Override
    public Method method() {
        return this.method;
    }

    int overloadId() {
        return this.overloadId;
    }

    List<AnnotatedValueResolver> annotatedValueResolvers() {
        return this.resolvers;
    }

    @Override
    public Route route() {
        return this.route;
    }

    @Override
    public HttpStatus defaultStatus() {
        return this.defaultStatus;
    }

    HttpService withExceptionHandler(HttpService service) {
        if (this.exceptionHandler == null) {
            return service;
        }
        return new ExceptionHandlingHttpService(service, this.exceptionHandler);
    }

    @Override
    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        if (!this.defaultHttpHeaders.isEmpty()) {
            ctx.mutateAdditionalResponseHeaders(mutator -> mutator.add(this.defaultHttpHeaders));
        }
        if (!this.defaultHttpTrailers.isEmpty()) {
            ctx.mutateAdditionalResponseTrailers(mutator -> mutator.add(this.defaultHttpTrailers));
        }
        HttpResponse response = this.serve0(ctx, req);
        if (this.exceptionHandler == null && Flags.annotatedServiceExceptionVerbosity() == ExceptionVerbosity.ALL && logger.isWarnEnabled()) {
            return response.peekError(cause -> logger.warn("{} Exception raised by method '{}' in '{}':", new Object[]{ctx, this.methodName(), this.object.getClass().getSimpleName(), Exceptions.peel(cause)}));
        }
        return response;
    }

    private HttpResponse serve0(ServiceRequestContext ctx, HttpRequest req) {
        AnnotatedValueResolver.AggregationType aggregationType = AnnotatedValueResolver.aggregationType(this.aggregationStrategy, req.headers());
        if (aggregationType == AnnotatedValueResolver.AggregationType.NONE && !this.useBlockingTaskExecutor) {
            switch (this.responseType.ordinal()) {
                case 0: {
                    return (HttpResponse)this.invoke(ctx, req, AnnotatedValueResolver.AggregatedResult.EMPTY);
                }
                case 4: {
                    return this.convertResponse(ctx, this.invoke(ctx, req, AnnotatedValueResolver.AggregatedResult.EMPTY));
                }
            }
        }
        return HttpResponse.of(this.serve1(ctx, req, aggregationType));
    }

    private CompletionStage<HttpResponse> serve1(ServiceRequestContext ctx, HttpRequest req, AnnotatedValueResolver.AggregationType aggregationType) {
        CompletionStage<AnnotatedValueResolver.AggregatedResult> f;
        switch (aggregationType) {
            case MULTIPART: {
                f = FileAggregatedMultipart.aggregateMultipart(ctx, req).thenApply(AnnotatedValueResolver.AggregatedResult::new);
                break;
            }
            case ALL: {
                f = req.aggregate().thenApply(AnnotatedValueResolver.AggregatedResult::new);
                break;
            }
            case NONE: {
                f = NO_AGGREGATION_FUTURE;
                break;
            }
            default: {
                throw new Error();
            }
        }
        switch (this.responseType.ordinal()) {
            case 0: {
                if (this.useBlockingTaskExecutor) {
                    return ((CompletableFuture)f).thenApplyAsync(aReq -> (HttpResponse)this.invoke(ctx, req, (AnnotatedValueResolver.AggregatedResult)aReq), (Executor)ctx.blockingTaskExecutor());
                }
                return ((CompletableFuture)f).thenApply(aReq -> (HttpResponse)this.invoke(ctx, req, (AnnotatedValueResolver.AggregatedResult)aReq));
            }
            case 1: 
            case 2: 
            case 3: {
                CompletionStage composedFuture = this.useBlockingTaskExecutor ? ((CompletableFuture)f).thenComposeAsync(aReq -> DefaultAnnotatedService.toCompletionStage(this.invoke(ctx, req, (AnnotatedValueResolver.AggregatedResult)aReq), ctx.blockingTaskExecutor()), (Executor)ctx.blockingTaskExecutor()) : ((CompletableFuture)f).thenCompose(aReq -> DefaultAnnotatedService.toCompletionStage(this.invoke(ctx, req, (AnnotatedValueResolver.AggregatedResult)aReq), ctx.eventLoop()));
                return ((CompletableFuture)composedFuture).thenApply(result -> this.convertResponse(ctx, result));
            }
        }
        Function<AnnotatedValueResolver.AggregatedResult, HttpResponse> defaultApplyFunction = aReq -> this.convertResponse(ctx, this.invoke(ctx, req, (AnnotatedValueResolver.AggregatedResult)aReq));
        if (this.useBlockingTaskExecutor) {
            return ((CompletableFuture)f).thenApplyAsync(defaultApplyFunction, (Executor)ctx.blockingTaskExecutor());
        }
        return ((CompletableFuture)f).thenApply(defaultApplyFunction);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private Object invoke(ServiceRequestContext ctx, HttpRequest req, AnnotatedValueResolver.AggregatedResult aggregatedResult) {
        try (SafeCloseable ignored = ctx.push();){
            AnnotatedValueResolver.ResolverContext resolverContext = new AnnotatedValueResolver.ResolverContext(ctx, req, aggregatedResult);
            Object[] arguments = AnnotatedValueResolver.toArguments(this.resolvers, resolverContext);
            if (this.isKotlinSuspendingMethod) {
                assert (this.callKotlinSuspendingMethod != null);
                BlockingTaskExecutor executor = this.useBlockingTaskExecutor ? ctx.blockingTaskExecutor().withoutContext() : ctx.eventLoop().withoutContext();
                Object object = this.callKotlinSuspendingMethod.invoke(this.method, this.object, arguments, executor, ctx);
                return object;
            }
            Object object = this.methodHandle.invoke(arguments);
            return object;
        }
        catch (Throwable cause) {
            return HttpResponse.ofFailure(cause);
        }
    }

    private HttpResponse convertResponse(ServiceRequestContext ctx, @Nullable Object result) {
        HttpHeaders trailers;
        ResponseHeaders headers;
        if (result instanceof HttpResponse) {
            return (HttpResponse)result;
        }
        if (result instanceof AggregatedHttpResponse) {
            return ((AggregatedHttpResponse)result).toHttpResponse();
        }
        if (result instanceof ResponseEntity) {
            ResponseEntity responseEntity = (ResponseEntity)result;
            headers = ResponseEntityUtil.buildResponseHeaders(ctx, responseEntity);
            result = responseEntity.hasContent() ? responseEntity.content() : null;
            trailers = responseEntity.trailers();
        } else if (result instanceof HttpResult) {
            HttpResult httpResult = (HttpResult)result;
            headers = HttpResultUtil.buildResponseHeaders(ctx, httpResult);
            result = httpResult.content();
            trailers = httpResult.trailers();
        } else {
            headers = this.buildResponseHeaders(ctx);
            trailers = HttpHeaders.of();
        }
        return this.convertResponseInternal(ctx, headers, result, trailers);
    }

    private HttpResponse convertResponseInternal(ServiceRequestContext ctx, ResponseHeaders headers, @Nullable Object result, HttpHeaders trailers) {
        if (result instanceof CompletionStage) {
            CompletionStage future = (CompletionStage)result;
            return HttpResponse.of(future.thenApply(object -> this.convertResponseInternal(ctx, headers, object, trailers)));
        }
        SafeCloseable ignored = ctx.push();
        try {
            HttpResponse httpResponse = this.responseConverter.convertResponse(ctx, headers, result, trailers);
            if (ignored != null) {
                ignored.close();
            }
            return httpResponse;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception cause) {
                return HttpResponse.ofFailure(cause);
            }
        }
    }

    private ResponseHeaders buildResponseHeaders(ServiceRequestContext ctx) {
        ResponseHeadersBuilder builder = ResponseHeaders.builder(this.defaultStatus);
        if (builder.status().isContentAlwaysEmpty()) {
            return builder.build();
        }
        MediaType negotiatedResponseMediaType = ctx.negotiatedResponseMediaType();
        if (negotiatedResponseMediaType != null) {
            builder.contentType(negotiatedResponseMediaType);
        }
        return builder.build();
    }

    private static CompletionStage<?> toCompletionStage(@Nullable Object obj, ExecutorService executor) {
        if (obj instanceof CompletionStage) {
            return (CompletionStage)obj;
        }
        if (obj != null && ScalaUtil.isScalaFuture(obj.getClass())) {
            return ScalaUtil.FutureConverter.toCompletableFuture((Future)obj, executor);
        }
        return UnmodifiableFuture.completedFuture(obj);
    }

    @Override
    public ExchangeType exchangeType(RoutingContext routingContext) {
        boolean isRequestStreaming = AnnotatedValueResolver.aggregationType(this.aggregationStrategy, routingContext.headers()) != AnnotatedValueResolver.AggregationType.ALL;
        Boolean isResponseStreaming = this.responseConverter.isResponseStreaming(this.actualReturnType, routingContext.result().routingResult().negotiatedResponseMediaType());
        if (isResponseStreaming == null) {
            isResponseStreaming = true;
        }
        if (isRequestStreaming) {
            return isResponseStreaming != false ? ExchangeType.BIDI_STREAMING : ExchangeType.REQUEST_STREAMING;
        }
        return isResponseStreaming != false ? ExchangeType.RESPONSE_STREAMING : ExchangeType.UNARY;
    }

    @Override
    public ServiceOptions options() {
        return this.options;
    }

    private static MethodHandle asMethodHandle(Method method, @Nullable Object object) {
        MethodHandle methodHandle;
        try {
            methodHandle = lookup.unreflect(method);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            methodHandle = methodHandle.bindTo(Objects.requireNonNull(object, "object"));
        }
        int parameterCount = method.getParameterCount();
        return methodHandle.asSpreader(Object[].class, parameterCount);
    }

    private static final class CompositeExceptionHandlerFunction
    implements ExceptionHandlerFunction {
        private final String className;
        private final String methodName;
        private final List<ExceptionHandlerFunction> functions;

        CompositeExceptionHandlerFunction(String className, String methodName, List<ExceptionHandlerFunction> functions) {
            this.className = className;
            this.methodName = methodName;
            this.functions = ImmutableList.copyOf(functions);
        }

        @Override
        public HttpResponse handleException(ServiceRequestContext ctx, HttpRequest req, Throwable cause) {
            Throwable peeledCause = Exceptions.peel(cause);
            if (Flags.annotatedServiceExceptionVerbosity() == ExceptionVerbosity.ALL && logger.isWarnEnabled()) {
                logger.warn("{} Exception raised by method '{}' in '{}':", new Object[]{ctx, this.methodName, this.className, peeledCause});
            }
            for (ExceptionHandlerFunction func : this.functions) {
                try {
                    HttpResponse response = func.handleException(ctx, req, peeledCause);
                    if (response != null) {
                        return response;
                    }
                    break;
                }
                catch (FallthroughException response) {
                }
                catch (Exception e) {
                    logger.warn("{} Unexpected exception from an exception handler {}:", new Object[]{ctx, func.getClass().getName(), e});
                }
            }
            return HttpResponse.ofFailure(peeledCause);
        }
    }

    private static enum ResponseType {
        HTTP_RESPONSE,
        COMPLETION_STAGE,
        KOTLIN_COROUTINES,
        SCALA_FUTURE,
        OTHER_OBJECTS;

    }

    private static final class ExceptionHandlingHttpService
    extends SimpleDecoratingHttpService {
        private final ExceptionHandlerFunction exceptionHandler;

        ExceptionHandlingHttpService(HttpService service, ExceptionHandlerFunction exceptionHandler) {
            super(service);
            this.exceptionHandler = exceptionHandler;
        }

        @Override
        public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) {
            try {
                HttpResponse response = (HttpResponse)((Service)this.unwrap()).serve(ctx, req);
                return response.recover(cause -> {
                    try (SafeCloseable ignored = ctx.push();){
                        HttpResponse httpResponse = this.exceptionHandler.handleException(ctx, req, (Throwable)cause);
                        return httpResponse;
                    }
                });
            }
            catch (Exception ex) {
                return this.exceptionHandler.handleException(ctx, req, ex);
            }
        }
    }
}

