/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.client.dns;

import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

final class DnsQuestionContext {
    private final long queryTimeoutMillis;
    private final CompletableFuture<Void> whenCancelled = new CompletableFuture();
    private final ScheduledFuture<?> scheduledFuture;

    DnsQuestionContext(EventExecutor executor, long queryTimeoutMillis) {
        this.queryTimeoutMillis = queryTimeoutMillis;
        this.scheduledFuture = executor.schedule(() -> this.whenCancelled.cancel(true), queryTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    long queryTimeoutMillis() {
        return this.queryTimeoutMillis;
    }

    CompletableFuture<Void> whenCancelled() {
        return this.whenCancelled;
    }

    boolean isCancelled() {
        return this.whenCancelled.isCompletedExceptionally();
    }

    void cancel() {
        if (!this.scheduledFuture.isDone()) {
            this.scheduledFuture.cancel(false);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DnsQuestionContext)) {
            return false;
        }
        DnsQuestionContext that = (DnsQuestionContext)o;
        return this.queryTimeoutMillis == that.queryTimeoutMillis && this.whenCancelled.equals(that.whenCancelled) && this.scheduledFuture.equals(that.scheduledFuture);
    }

    public int hashCode() {
        int result = this.whenCancelled.hashCode();
        result = 31 * result + this.scheduledFuture.hashCode();
        result = 31 * result + (int)this.queryTimeoutMillis;
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("queryTimeoutMillis", this.queryTimeoutMillis).add("whenCancelled", this.whenCancelled).add("scheduledFuture", this.scheduledFuture).toString();
    }
}

