/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.stream;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.stream.AbortedStreamException;
import com.linecorp.armeria.common.stream.CancelledSubscriptionException;
import com.linecorp.armeria.common.stream.NoopSubscriber;
import com.linecorp.armeria.common.stream.StreamMessage;
import com.linecorp.armeria.common.stream.SubscriptionOption;
import com.linecorp.armeria.internal.common.stream.InternalStreamMessageUtil;
import com.linecorp.armeria.internal.common.stream.NoopSubscription;
import com.linecorp.armeria.internal.common.stream.SubscriptionArbiter;
import io.netty.util.concurrent.EventExecutor;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class ConcatArrayStreamMessage<T>
implements StreamMessage<T> {
    private static final AtomicIntegerFieldUpdater<ConcatArrayStreamMessage> subscribedUpdater = AtomicIntegerFieldUpdater.newUpdater(ConcatArrayStreamMessage.class, "subscribed");
    private final List<StreamMessage<? extends T>> sources;
    @Nullable
    private ConcatArraySubscriber<T> parent;
    private volatile int subscribed;

    ConcatArrayStreamMessage(List<StreamMessage<? extends T>> sources) {
        assert (!sources.isEmpty());
        this.sources = sources;
    }

    @Override
    public boolean isOpen() {
        for (StreamMessage<T> source : this.sources) {
            if (!source.isOpen()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        for (StreamMessage<T> source : this.sources) {
            if (source.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public long demand() {
        if (this.parent == null) {
            return 0L;
        }
        return this.sources.get(((ConcatArraySubscriber)this.parent).index).demand();
    }

    @Override
    public CompletableFuture<Void> whenComplete() {
        return this.sources.get(this.sources.size() - 1).whenComplete();
    }

    @Override
    public void subscribe(Subscriber<? super T> subscriber, EventExecutor executor, SubscriptionOption ... options) {
        Objects.requireNonNull(subscriber, "subscriber");
        Objects.requireNonNull(executor, "executor");
        Objects.requireNonNull(options, "options");
        if (subscribedUpdater.compareAndSet(this, 0, 1)) {
            this.parent = new ConcatArraySubscriber<T>(subscriber, this.sources, executor, options);
            subscriber.onSubscribe(this.parent);
            if (executor.inEventLoop()) {
                this.parent.nextSource();
            } else {
                executor.execute(() -> this.parent.nextSource());
            }
        } else {
            subscriber.onSubscribe((Subscription)NoopSubscription.get());
            subscriber.onError((Throwable)new IllegalStateException("subscribed by other subscriber already"));
        }
    }

    @Override
    public void abort() {
        this.abort(AbortedStreamException.get());
    }

    @Override
    public void abort(Throwable cause) {
        Objects.requireNonNull(cause, "cause");
        for (StreamMessage<T> source : this.sources) {
            source.abort(cause);
        }
    }

    private static final class ConcatArraySubscriber<T>
    extends SubscriptionArbiter
    implements Subscriber<T> {
        private static final AtomicIntegerFieldUpdater<ConcatArraySubscriber> cancelledUpdater = AtomicIntegerFieldUpdater.newUpdater(ConcatArraySubscriber.class, "cancelled");
        private Subscriber<? super T> downstream;
        private final List<StreamMessage<? extends T>> sources;
        private final EventExecutor executor;
        private final SubscriptionOption[] options;
        private long produced;
        private volatile int index;
        private volatile int cancelled;

        ConcatArraySubscriber(Subscriber<? super T> downstream, List<StreamMessage<? extends T>> sources, EventExecutor executor, SubscriptionOption ... options) {
            super(executor);
            this.downstream = downstream;
            this.sources = sources;
            this.executor = executor;
            this.options = options;
        }

        public void onSubscribe(Subscription subscription) {
            if (this.cancelled()) {
                subscription.cancel();
            } else {
                this.setUpstreamSubscription(subscription);
            }
        }

        public void onNext(T item) {
            Objects.requireNonNull(item, "item");
            ++this.produced;
            this.downstream.onNext(item);
        }

        public void onError(Throwable throwable) {
            Objects.requireNonNull(throwable, "throwable");
            this.abortUnsubscribedSources(throwable);
            this.downstream.onError(throwable);
        }

        public void onComplete() {
            long produced = this.produced;
            if (produced != 0L) {
                this.produced = 0L;
                this.produced(produced);
            }
            this.nextSource();
        }

        void nextSource() {
            if (!this.cancelled()) {
                int index;
                if ((index = this.index++) == this.sources.size()) {
                    this.downstream.onComplete();
                } else {
                    this.sources.get(index).subscribe(this, this.executor, this.options);
                }
            }
        }

        @Override
        public void request(long n) {
            if (n <= 0L) {
                this.downstream.onError((Throwable)new IllegalArgumentException("Rule \u00a73.9 violated: non-positive requests are forbidden"));
            } else {
                super.request(n);
            }
        }

        @Override
        public void cancel() {
            if (cancelledUpdater.compareAndSet(this, 0, 1)) {
                super.cancel();
                CancelledSubscriptionException cause = CancelledSubscriptionException.get();
                if (InternalStreamMessageUtil.containsNotifyCancellation(this.options)) {
                    this.downstream.onError((Throwable)cause);
                }
                this.downstream = NoopSubscriber.get();
                this.abortUnsubscribedSources(cause);
            }
        }

        private boolean cancelled() {
            return this.cancelled != 0;
        }

        private void abortUnsubscribedSources(Throwable cause) {
            int index;
            for (int i = index = this.index; i < this.sources.size(); ++i) {
                this.sources.get(i).abort(cause);
            }
        }
    }
}

