/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logging;

import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.HttpStatusClass;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.logging.LogFormatter;
import com.linecorp.armeria.common.logging.LogLevel;
import com.linecorp.armeria.common.logging.LogWriter;
import com.linecorp.armeria.common.logging.LogWriterBuilder;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogLevelMapper;
import com.linecorp.armeria.common.logging.RequestOnlyLog;
import com.linecorp.armeria.common.logging.ResponseLogLevelMapper;
import com.linecorp.armeria.common.logging.TextLogFormatterBuilder;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LoggingDecoratorBuilder {
    @Nullable
    private LogWriter logWriter;
    @Nullable
    private Logger defaultLogger;
    @Nullable
    private LogWriterBuilder logWriterBuilder;
    @Nullable
    private TextLogFormatterBuilder logFormatterBuilder;

    private static <T, U> BiFunction<T, U, @Nullable String> convertToStringSanitizer(BiFunction<T, U, ? extends @Nullable Object> originalSanitizer) {
        return (first, second) -> {
            Object sanitized = originalSanitizer.apply(first, second);
            return sanitized != null ? sanitized.toString() : null;
        };
    }

    protected LoggingDecoratorBuilder defaultLogger(Logger defaultLogger) {
        Objects.requireNonNull(defaultLogger, "defaultLogger");
        this.defaultLogger = defaultLogger;
        return this;
    }

    @Deprecated
    public LoggingDecoratorBuilder logger(Logger logger) {
        this.maybeCreateLogWriterBuilder();
        this.logWriterBuilder.logger(logger);
        return this;
    }

    @Deprecated
    public LoggingDecoratorBuilder logger(String loggerName) {
        Objects.requireNonNull(loggerName, "loggerName");
        this.maybeCreateLogWriterBuilder();
        this.logWriterBuilder.logger(LoggerFactory.getLogger((String)loggerName));
        return this;
    }

    @Nullable
    protected final Logger logger() {
        if (this.logWriterBuilder != null) {
            return this.logWriterBuilder.logger();
        }
        return null;
    }

    @Deprecated
    public LoggingDecoratorBuilder requestLogLevel(LogLevel requestLogLevel) {
        this.maybeCreateLogWriterBuilder();
        this.logWriterBuilder.requestLogLevel(requestLogLevel);
        return this;
    }

    @Deprecated
    public LoggingDecoratorBuilder requestLogLevel(Class<? extends Throwable> clazz, LogLevel requestLogLevel) {
        this.maybeCreateLogWriterBuilder();
        this.logWriterBuilder.requestLogLevel(clazz, requestLogLevel);
        return this;
    }

    @Deprecated
    public LoggingDecoratorBuilder requestLogLevelMapper(Function<? super RequestOnlyLog, LogLevel> requestLogLevelMapper) {
        Objects.requireNonNull(requestLogLevelMapper, "requestLogLevelMapper");
        this.maybeCreateLogWriterBuilder();
        this.logWriterBuilder.requestLogLevelMapper(requestLogLevelMapper::apply);
        return this;
    }

    @Deprecated
    public LoggingDecoratorBuilder requestLogLevelMapper(RequestLogLevelMapper requestLogLevelMapper) {
        this.maybeCreateLogWriterBuilder();
        this.logWriterBuilder.requestLogLevelMapper(requestLogLevelMapper);
        return this;
    }

    @Deprecated
    @Nullable
    protected final RequestLogLevelMapper requestLogLevelMapper() {
        if (this.logWriterBuilder != null) {
            return this.logWriterBuilder.requestLogLevelMapper();
        }
        return null;
    }

    @Deprecated
    public LoggingDecoratorBuilder responseLogLevel(HttpStatus status, LogLevel logLevel) {
        this.maybeCreateLogWriterBuilder();
        this.logWriterBuilder.responseLogLevel(status, logLevel);
        return this;
    }

    @Deprecated
    public LoggingDecoratorBuilder responseLogLevel(HttpStatusClass statusClass, LogLevel logLevel) {
        this.maybeCreateLogWriterBuilder();
        this.logWriterBuilder.responseLogLevel(statusClass, logLevel);
        return this;
    }

    @Deprecated
    public LoggingDecoratorBuilder responseLogLevel(Class<? extends Throwable> clazz, LogLevel logLevel) {
        this.maybeCreateLogWriterBuilder();
        this.logWriterBuilder.responseLogLevel(clazz, logLevel);
        return this;
    }

    @Deprecated
    public LoggingDecoratorBuilder successfulResponseLogLevel(LogLevel successfulResponseLogLevel) {
        this.maybeCreateLogWriterBuilder();
        this.logWriterBuilder.successfulResponseLogLevel(successfulResponseLogLevel);
        return this;
    }

    @Deprecated
    public LoggingDecoratorBuilder failureResponseLogLevel(LogLevel failedResponseLogLevel) {
        this.maybeCreateLogWriterBuilder();
        this.logWriterBuilder.failureResponseLogLevel(failedResponseLogLevel);
        return this;
    }

    @Deprecated
    public LoggingDecoratorBuilder responseLogLevelMapper(Function<? super RequestLog, LogLevel> responseLogLevelMapper) {
        Objects.requireNonNull(responseLogLevelMapper, "responseLogLevelMapper");
        this.maybeCreateLogWriterBuilder();
        return this.responseLogLevelMapper(responseLogLevelMapper::apply);
    }

    @Deprecated
    public LoggingDecoratorBuilder responseLogLevelMapper(ResponseLogLevelMapper responseLogLevelMapper) {
        this.maybeCreateLogWriterBuilder();
        this.logWriterBuilder.responseLogLevelMapper(responseLogLevelMapper);
        return this;
    }

    @Deprecated
    @Nullable
    protected final ResponseLogLevelMapper responseLogLevelMapper() {
        if (this.logWriterBuilder != null) {
            return this.logWriterBuilder.responseLogLevelMapper();
        }
        return null;
    }

    @Deprecated
    public LoggingDecoratorBuilder requestHeadersSanitizer(BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> requestHeadersSanitizer) {
        Objects.requireNonNull(requestHeadersSanitizer, "requestHeadersSanitizer");
        this.maybeCreateLogWriterBuilder();
        this.logFormatterBuilder.requestHeadersSanitizer(LoggingDecoratorBuilder.convertToStringSanitizer(requestHeadersSanitizer));
        return this;
    }

    @Deprecated
    @Nullable
    protected final @Nullable BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> requestHeadersSanitizer() {
        if (this.logFormatterBuilder != null) {
            return this.logFormatterBuilder.requestHeadersSanitizer();
        }
        return null;
    }

    @Deprecated
    public LoggingDecoratorBuilder responseHeadersSanitizer(BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> responseHeadersSanitizer) {
        this.maybeCreateLogWriterBuilder();
        Objects.requireNonNull(responseHeadersSanitizer, "responseHeadersSanitizer");
        this.logFormatterBuilder.responseHeadersSanitizer(LoggingDecoratorBuilder.convertToStringSanitizer(responseHeadersSanitizer));
        return this;
    }

    @Nullable
    @Deprecated
    protected final @Nullable BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> responseHeadersSanitizer() {
        if (this.logFormatterBuilder != null) {
            return this.logFormatterBuilder.responseHeadersSanitizer();
        }
        return null;
    }

    @Deprecated
    public LoggingDecoratorBuilder requestTrailersSanitizer(BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> requestTrailersSanitizer) {
        Objects.requireNonNull(requestTrailersSanitizer, "requestTrailersSanitizer");
        this.maybeCreateLogWriterBuilder();
        this.logFormatterBuilder.requestTrailersSanitizer(LoggingDecoratorBuilder.convertToStringSanitizer(requestTrailersSanitizer));
        return this;
    }

    @Deprecated
    @Nullable
    protected final @Nullable BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> requestTrailersSanitizer() {
        if (this.logFormatterBuilder != null) {
            return this.logFormatterBuilder.requestTrailersSanitizer();
        }
        return null;
    }

    @Deprecated
    public LoggingDecoratorBuilder responseTrailersSanitizer(BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> responseTrailersSanitizer) {
        Objects.requireNonNull(responseTrailersSanitizer, "responseTrailersSanitizer");
        this.maybeCreateLogWriterBuilder();
        this.logFormatterBuilder.responseTrailersSanitizer(LoggingDecoratorBuilder.convertToStringSanitizer(responseTrailersSanitizer));
        return this;
    }

    @Nullable
    @Deprecated
    protected final @Nullable BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> responseTrailersSanitizer() {
        if (this.logFormatterBuilder != null) {
            return this.logFormatterBuilder.responseTrailersSanitizer();
        }
        return null;
    }

    @Deprecated
    public LoggingDecoratorBuilder headersSanitizer(BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> headersSanitizer) {
        Objects.requireNonNull(headersSanitizer, "headersSanitizer");
        this.requestHeadersSanitizer(headersSanitizer);
        this.requestTrailersSanitizer(headersSanitizer);
        this.responseHeadersSanitizer(headersSanitizer);
        this.responseTrailersSanitizer(headersSanitizer);
        return this;
    }

    @Deprecated
    public LoggingDecoratorBuilder requestContentSanitizer(BiFunction<? super RequestContext, Object, ? extends @Nullable Object> requestContentSanitizer) {
        Objects.requireNonNull(requestContentSanitizer, "requestContentSanitizer");
        this.maybeCreateLogWriterBuilder();
        this.logFormatterBuilder.requestContentSanitizer(LoggingDecoratorBuilder.convertToStringSanitizer(requestContentSanitizer));
        return this;
    }

    @Nullable
    @Deprecated
    protected final @Nullable BiFunction<? super RequestContext, Object, ? extends @Nullable Object> requestContentSanitizer() {
        if (this.logFormatterBuilder != null) {
            return this.logFormatterBuilder.requestContentSanitizer();
        }
        return null;
    }

    @Deprecated
    public LoggingDecoratorBuilder responseContentSanitizer(BiFunction<? super RequestContext, Object, ? extends @Nullable Object> responseContentSanitizer) {
        Objects.requireNonNull(responseContentSanitizer, "responseContentSanitizer");
        this.maybeCreateLogWriterBuilder();
        this.logFormatterBuilder.responseContentSanitizer(LoggingDecoratorBuilder.convertToStringSanitizer(responseContentSanitizer));
        return this;
    }

    @Nullable
    @Deprecated
    protected final @Nullable BiFunction<? super RequestContext, Object, ? extends @Nullable Object> responseContentSanitizer() {
        if (this.logFormatterBuilder != null) {
            return this.logFormatterBuilder.responseContentSanitizer();
        }
        return null;
    }

    @Deprecated
    public LoggingDecoratorBuilder contentSanitizer(BiFunction<? super RequestContext, Object, ? extends @Nullable Object> contentSanitizer) {
        Objects.requireNonNull(contentSanitizer, "contentSanitizer");
        this.requestContentSanitizer(contentSanitizer);
        this.responseContentSanitizer(contentSanitizer);
        return this;
    }

    @Deprecated
    public LoggingDecoratorBuilder responseCauseSanitizer(BiFunction<? super RequestContext, ? super Throwable, ? extends @Nullable Object> responseCauseSanitizer) {
        Objects.requireNonNull(responseCauseSanitizer, "responseCauseSanitizer");
        this.maybeCreateLogWriterBuilder();
        this.logWriterBuilder.responseCauseFilter((? super RequestContext ctx, ? super Throwable cause) -> responseCauseSanitizer.apply((RequestContext)ctx, (Throwable)cause) != null);
        return this;
    }

    @Nullable
    @Deprecated
    protected final @Nullable BiFunction<? super RequestContext, ? super Throwable, ? extends @Nullable Object> responseCauseSanitizer() {
        return null;
    }

    @Deprecated
    public LoggingDecoratorBuilder responseCauseFilter(Predicate<Throwable> responseCauseFilter) {
        Objects.requireNonNull(responseCauseFilter, "responseCauseFilter");
        this.maybeCreateLogWriterBuilder();
        this.logWriterBuilder.responseCauseFilter((? super RequestContext ctx, ? super Throwable cause) -> responseCauseFilter.test((Throwable)cause));
        return this;
    }

    @UnstableApi
    public LoggingDecoratorBuilder logWriter(LogWriter logWriter) {
        if (this.logWriterBuilder != null) {
            throw new IllegalStateException("The logWriter and the log properties cannot be set together.");
        }
        this.logWriter = Objects.requireNonNull(logWriter, "logWriter");
        return this;
    }

    protected final LogWriter logWriter() {
        if (this.logWriter != null) {
            return this.logWriter;
        }
        if (this.logWriterBuilder == null) {
            if (this.defaultLogger != null) {
                return LogWriter.of(this.defaultLogger);
            }
            return LogWriter.of();
        }
        assert (this.logFormatterBuilder != null);
        LogFormatter logFormatter = this.logFormatterBuilder.build();
        this.logWriterBuilder.logFormatter(logFormatter);
        if (this.logWriterBuilder.logger() == null && this.defaultLogger != null) {
            this.logWriterBuilder.logger(this.defaultLogger);
        }
        return this.logWriterBuilder.build();
    }

    private void maybeCreateLogWriterBuilder() {
        if (this.logWriter != null) {
            throw new IllegalStateException("The logWriter and the log properties cannot be set together.");
        }
        if (this.logWriterBuilder != null) {
            return;
        }
        this.logWriterBuilder = LogWriter.builder();
        this.logFormatterBuilder = LogFormatter.builderForText();
    }
}

