/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logging;

import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.logging.LogFormatter;
import com.linecorp.armeria.common.logging.LogLevel;
import com.linecorp.armeria.common.logging.LogWriter;
import com.linecorp.armeria.common.logging.LogWriterBuilder;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogLevelMapper;
import com.linecorp.armeria.common.logging.RequestOnlyLog;
import com.linecorp.armeria.common.logging.ResponseLogLevelMapper;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import java.util.Objects;
import java.util.function.BiPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultLogWriter
implements LogWriter {
    static final Logger defaultLogger = LoggerFactory.getLogger(LogWriter.class);
    static final DefaultLogWriter DEFAULT = new DefaultLogWriter(defaultLogger, LogWriterBuilder.DEFAULT_REQUEST_LOG_LEVEL_MAPPER, LogWriterBuilder.DEFAULT_RESPONSE_LOG_LEVEL_MAPPER, (ctx, throwable) -> false, LogFormatter.ofText());
    private static boolean warnedNullRequestLogLevelMapper;
    private static boolean warnedNullResponseLogLevelMapper;
    private final Logger logger;
    private final RequestLogLevelMapper requestLogLevelMapper;
    private final ResponseLogLevelMapper responseLogLevelMapper;
    private final BiPredicate<? super RequestContext, ? super Throwable> responseCauseFilter;
    private final LogFormatter logFormatter;

    DefaultLogWriter(Logger logger, RequestLogLevelMapper requestLogLevelMapper, ResponseLogLevelMapper responseLogLevelMapper, BiPredicate<? super RequestContext, ? super Throwable> responseCauseFilter, LogFormatter logFormatter) {
        this.logger = logger;
        this.requestLogLevelMapper = requestLogLevelMapper;
        this.responseLogLevelMapper = responseLogLevelMapper;
        this.responseCauseFilter = responseCauseFilter;
        this.logFormatter = logFormatter;
    }

    @Override
    public void logRequest(RequestOnlyLog log) {
        Objects.requireNonNull(log, "log");
        LogLevel requestLogLevel = this.requestLogLevelMapper.apply(log);
        if (requestLogLevel == null) {
            if (!warnedNullRequestLogLevelMapper) {
                warnedNullRequestLogLevelMapper = true;
                this.logger.warn("requestLogLevelMapper.apply() returned null; using default log level");
            }
            requestLogLevel = LogWriterBuilder.DEFAULT_REQUEST_LOG_LEVEL;
        }
        if (requestLogLevel.isEnabled(this.logger)) {
            try (SafeCloseable ignored = log.context().push();){
                requestLogLevel.log(this.logger, this.logFormatter.formatRequest(log));
            }
        }
    }

    @Override
    public void logResponse(RequestLog log) {
        Objects.requireNonNull(log, "log");
        LogLevel responseLogLevel = this.responseLogLevelMapper.apply(log);
        if (responseLogLevel == null) {
            if (!warnedNullResponseLogLevelMapper) {
                warnedNullResponseLogLevelMapper = true;
                this.logger.warn("responseLogLevelMapper.apply() returned null; using default log level mapper");
            }
            responseLogLevel = LogWriterBuilder.DEFAULT_RESPONSE_LOG_LEVEL_MAPPER.apply(log);
            assert (responseLogLevel != null);
        }
        Throwable responseCause = log.responseCause();
        if (responseLogLevel.isEnabled(this.logger)) {
            String responseStr = this.logFormatter.formatResponse(log);
            RequestContext ctx = log.context();
            try (SafeCloseable ignored = ctx.push();){
                if (responseCause == null) {
                    responseLogLevel.log(this.logger, responseStr);
                    return;
                }
                LogLevel requestLogLevel = this.requestLogLevelMapper.apply(log);
                assert (requestLogLevel != null);
                if (!requestLogLevel.isEnabled(this.logger)) {
                    responseLogLevel.log(this.logger, this.logFormatter.formatRequest(log));
                }
                if (this.responseCauseFilter.test(ctx, responseCause)) {
                    responseLogLevel.log(this.logger, responseStr);
                } else {
                    responseLogLevel.log(this.logger, responseStr, (Object)responseCause);
                }
            }
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("logger", this.logger).add("requestLogLevelMapper", this.requestLogLevelMapper).add("responseLogLevelMapper", this.responseLogLevelMapper).add("responseCauseFilter", this.responseCauseFilter).add("logFormatter", this.logFormatter).toString();
    }
}

