/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.ContextAwareFutureListener;
import com.linecorp.armeria.common.RequestContext;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ProgressivePromise;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class ContextAwareProgressivePromise<T>
implements ProgressivePromise<T> {
    private final RequestContext context;
    private final ProgressivePromise<T> delegate;

    ContextAwareProgressivePromise(RequestContext context, ProgressivePromise<T> delegate) {
        this.context = context;
        this.delegate = delegate;
    }

    public ProgressivePromise<T> setProgress(long progress, long total) {
        this.delegate.setProgress(progress, total);
        return this;
    }

    public boolean tryProgress(long progress, long total) {
        return this.delegate.tryProgress(progress, total);
    }

    public ProgressivePromise<T> setSuccess(T result) {
        this.delegate.setSuccess(result);
        return this;
    }

    public ProgressivePromise<T> setFailure(Throwable cause) {
        this.delegate.setFailure(cause);
        return this;
    }

    public ProgressivePromise<T> addListener(GenericFutureListener<? extends Future<? super T>> listener) {
        this.delegate.addListener(ContextAwareFutureListener.of(this.context, listener));
        return this;
    }

    @SafeVarargs
    public final ProgressivePromise<T> addListeners(GenericFutureListener<? extends Future<? super T>> ... listeners) {
        for (GenericFutureListener<? extends Future<? super T>> l : listeners) {
            this.delegate.addListeners(new GenericFutureListener[]{ContextAwareFutureListener.of(this.context, l)});
        }
        return this;
    }

    public ProgressivePromise<T> removeListener(GenericFutureListener<? extends Future<? super T>> listener) {
        throw new UnsupportedOperationException();
    }

    @SafeVarargs
    public final ProgressivePromise<T> removeListeners(GenericFutureListener<? extends Future<? super T>> ... listeners) {
        throw new UnsupportedOperationException();
    }

    public ProgressivePromise<T> sync() throws InterruptedException {
        this.delegate.sync();
        return this;
    }

    public ProgressivePromise<T> syncUninterruptibly() {
        this.delegate.syncUninterruptibly();
        return this;
    }

    public boolean trySuccess(T result) {
        return this.delegate.trySuccess(result);
    }

    public boolean tryFailure(Throwable cause) {
        return this.delegate.tryFailure(cause);
    }

    public boolean setUncancellable() {
        return this.delegate.setUncancellable();
    }

    public boolean isSuccess() {
        return this.delegate.isSuccess();
    }

    public boolean isCancellable() {
        return this.delegate.isCancellable();
    }

    public Throwable cause() {
        return this.delegate.cause();
    }

    public ProgressivePromise<T> await() throws InterruptedException {
        this.delegate.await();
        return this;
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.await(timeout, unit);
    }

    public boolean await(long timeoutMillis) throws InterruptedException {
        return this.delegate.await(timeoutMillis);
    }

    public ProgressivePromise<T> awaitUninterruptibly() {
        this.delegate.awaitUninterruptibly();
        return this;
    }

    public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
        return this.delegate.awaitUninterruptibly(timeout, unit);
    }

    public boolean awaitUninterruptibly(long timeoutMillis) {
        return this.delegate.awaitUninterruptibly(timeoutMillis);
    }

    public T getNow() {
        return (T)this.delegate.getNow();
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.delegate.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    public boolean isDone() {
        return this.delegate.isDone();
    }

    public T get() throws InterruptedException, ExecutionException {
        return (T)this.delegate.get();
    }

    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.delegate.get(timeout, unit);
    }
}

