/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.retry;

import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.ResponseTimeoutException;
import com.linecorp.armeria.client.RpcClient;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.retry.AbstractRetryingClient;
import com.linecorp.armeria.client.retry.Backoff;
import com.linecorp.armeria.client.retry.RetryConfig;
import com.linecorp.armeria.client.retry.RetryConfigMapping;
import com.linecorp.armeria.client.retry.RetryRuleWithContent;
import com.linecorp.armeria.client.retry.RetryingRpcClientBuilder;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.RpcRequest;
import com.linecorp.armeria.common.RpcResponse;
import com.linecorp.armeria.internal.client.ClientPendingThrowableUtil;
import com.linecorp.armeria.internal.client.ClientRequestContextExtension;
import com.linecorp.armeria.internal.client.ClientUtil;
import com.linecorp.armeria.internal.common.util.StringUtil;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public final class RetryingRpcClient
extends AbstractRetryingClient<RpcRequest, RpcResponse>
implements RpcClient {
    public static Function<? super RpcClient, RetryingRpcClient> newDecorator(RetryRuleWithContent<RpcResponse> retryRuleWithContent) {
        return RetryingRpcClient.builder(retryRuleWithContent).newDecorator();
    }

    @Deprecated
    public static Function<? super RpcClient, RetryingRpcClient> newDecorator(RetryRuleWithContent<RpcResponse> retryRuleWithContent, int maxTotalAttempts) {
        return RetryingRpcClient.builder(retryRuleWithContent).maxTotalAttempts(maxTotalAttempts).newDecorator();
    }

    @Deprecated
    public static Function<? super RpcClient, RetryingRpcClient> newDecorator(RetryRuleWithContent<RpcResponse> retryRuleWithContent, int maxTotalAttempts, long responseTimeoutMillisForEachAttempt) {
        return RetryingRpcClient.builder(retryRuleWithContent).maxTotalAttempts(maxTotalAttempts).responseTimeoutMillisForEachAttempt(responseTimeoutMillisForEachAttempt).newDecorator();
    }

    public static Function<? super RpcClient, RetryingRpcClient> newDecorator(RetryConfig<RpcResponse> retryConfig) {
        return RetryingRpcClient.builder(retryConfig).newDecorator();
    }

    public static Function<? super RpcClient, RetryingRpcClient> newDecorator(RetryConfigMapping<RpcResponse> mapping) {
        return RetryingRpcClient.builder(mapping).newDecorator();
    }

    public static RetryingRpcClientBuilder builder(RetryRuleWithContent<RpcResponse> retryRuleWithContent) {
        return new RetryingRpcClientBuilder(RetryConfig.builder0(retryRuleWithContent).build());
    }

    public static RetryingRpcClientBuilder builder(RetryConfig<RpcResponse> retryConfig) {
        return new RetryingRpcClientBuilder(retryConfig);
    }

    public static RetryingRpcClientBuilder builder(RetryConfigMapping<RpcResponse> mapping) {
        return new RetryingRpcClientBuilder(mapping);
    }

    RetryingRpcClient(RpcClient delegate, RetryConfigMapping<RpcResponse> mapping) {
        super(delegate, mapping, null);
    }

    @Override
    protected RpcResponse doExecute(ClientRequestContext ctx, RpcRequest req) throws Exception {
        CompletableFuture<RpcResponse> future = new CompletableFuture<RpcResponse>();
        RpcResponse res = RpcResponse.from(future);
        this.doExecute0(ctx, req, res, future);
        return res;
    }

    private void doExecute0(ClientRequestContext ctx, RpcRequest req, RpcResponse returnedRes, CompletableFuture<RpcResponse> future) {
        RpcResponse res;
        boolean initialAttempt;
        int totalAttempts = RetryingRpcClient.getTotalAttempts(ctx);
        boolean bl = initialAttempt = totalAttempts <= 1;
        if (returnedRes.isDone()) {
            RetryingRpcClient.handleException(ctx, future, new CancellationException("the response returned to the client has been cancelled"), initialAttempt);
            return;
        }
        if (!this.setResponseTimeout(ctx)) {
            RetryingRpcClient.handleException(ctx, future, ResponseTimeoutException.get(), initialAttempt);
            return;
        }
        ClientRequestContext derivedCtx = RetryingRpcClient.newDerivedContext(ctx, null, req, initialAttempt);
        if (!initialAttempt) {
            derivedCtx.mutateAdditionalRequestHeaders(mutator -> mutator.add((CharSequence)ARMERIA_RETRY_COUNT, StringUtil.toString(totalAttempts - 1)));
        }
        ClientRequestContextExtension ctxExtension = derivedCtx.as(ClientRequestContextExtension.class);
        EndpointGroup endpointGroup = derivedCtx.endpointGroup();
        if (!initialAttempt && ctxExtension != null && endpointGroup != null && derivedCtx.endpoint() == null) {
            ClientPendingThrowableUtil.removePendingThrowable(derivedCtx);
            res = ClientUtil.initContextAndExecuteWithFallback((Client)this.unwrap(), ctxExtension, endpointGroup, RpcResponse::from, (context, cause) -> RpcResponse.ofFailure(cause));
        } else {
            res = ClientUtil.executeWithFallback((Client)this.unwrap(), derivedCtx, (context, cause) -> RpcResponse.ofFailure(cause));
        }
        RetryConfig retryConfig = this.mappedRetryConfig(ctx);
        RetryRuleWithContent retryRule = retryConfig.needsContentInRule() ? retryConfig.retryRuleWithContent() : retryConfig.fromRetryRule();
        res.handle((unused1, cause) -> {
            try {
                retryRule.shouldRetry(derivedCtx, res, (Throwable)cause).handle((decision, unused3) -> {
                    Backoff backoff;
                    Backoff backoff2 = backoff = decision != null ? decision.backoff() : null;
                    if (backoff != null) {
                        long nextDelay = this.getNextDelay(derivedCtx, backoff);
                        if (nextDelay < 0L) {
                            RetryingRpcClient.onRetryComplete(ctx, derivedCtx, res, future);
                            return null;
                        }
                        RetryingRpcClient.scheduleNextRetry(ctx, cause0 -> RetryingRpcClient.handleException(ctx, future, cause0, false), () -> this.doExecute0(ctx, req, returnedRes, future), nextDelay);
                    } else {
                        RetryingRpcClient.onRetryComplete(ctx, derivedCtx, res, future);
                    }
                    return null;
                });
            }
            catch (Throwable t) {
                RetryingRpcClient.handleException(ctx, future, t, false);
            }
            return null;
        });
    }

    private static void onRetryComplete(ClientRequestContext ctx, ClientRequestContext derivedCtx, RpcResponse res, CompletableFuture<RpcResponse> future) {
        RetryingRpcClient.onRetryingComplete(ctx);
        HttpRequest actualHttpReq = derivedCtx.request();
        if (actualHttpReq != null) {
            ctx.updateRequest(actualHttpReq);
        }
        future.complete(res);
    }

    private static void handleException(ClientRequestContext ctx, CompletableFuture<RpcResponse> future, Throwable cause, boolean endRequestLog) {
        future.completeExceptionally(cause);
        if (endRequestLog) {
            ctx.logBuilder().endRequest(cause);
        }
        ctx.logBuilder().endResponse(cause);
    }
}

