/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.retry;

import com.linecorp.armeria.client.AbstractRuleWithContentBuilder;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.retry.Backoff;
import com.linecorp.armeria.client.retry.RetryDecision;
import com.linecorp.armeria.client.retry.RetryRule;
import com.linecorp.armeria.client.retry.RetryRuleBuilder;
import com.linecorp.armeria.client.retry.RetryRuleUtil;
import com.linecorp.armeria.client.retry.RetryRuleWithContent;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.Response;
import com.linecorp.armeria.internal.client.AbstractRuleBuilderUtil;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;

public final class RetryRuleWithContentBuilder<T extends Response>
extends AbstractRuleWithContentBuilder<RetryRuleWithContentBuilder<T>, T> {
    RetryRuleWithContentBuilder(BiPredicate<? super ClientRequestContext, ? super RequestHeaders> requestHeadersFilter) {
        super(requestHeadersFilter);
    }

    public RetryRuleWithContent<T> thenBackoff() {
        return this.thenBackoff(Backoff.ofDefault());
    }

    public RetryRuleWithContent<T> thenBackoff(Backoff backoff) {
        Objects.requireNonNull(backoff, "backoff");
        return this.build(RetryDecision.retry(backoff));
    }

    public RetryRuleWithContent<T> thenNoRetry() {
        return this.build(RetryDecision.noRetry());
    }

    RetryRuleWithContent<T> build(RetryDecision decision) {
        boolean hasResponseFilter;
        BiFunction responseFilter = this.responseFilter();
        boolean bl = hasResponseFilter = responseFilter != null;
        if (decision != RetryDecision.noRetry() && this.exceptionFilter() == null && this.responseHeadersFilter() == null && this.responseTrailersFilter() == null && this.grpcTrailersFilter() == null && !hasResponseFilter) {
            throw new IllegalStateException("Should set at least one retry rule if a backoff was set.");
        }
        BiFunction<? super ClientRequestContext, ? super Throwable, Boolean> ruleFilter = AbstractRuleBuilderUtil.buildFilter(this.requestHeadersFilter(), this.responseHeadersFilter(), this.responseTrailersFilter(), this.grpcTrailersFilter(), this.exceptionFilter(), this.totalDurationFilter(), hasResponseFilter);
        RetryRule first = RetryRuleBuilder.build(ruleFilter, decision, this.requiresResponseTrailers());
        if (!hasResponseFilter) {
            return RetryRuleUtil.fromRetryRule(first);
        }
        RetryRuleWithContent<Response> second = (ctx, content, cause) -> {
            if (content == null) {
                return RetryRuleUtil.NEXT_DECISION;
            }
            return ((CompletionStage)responseFilter.apply(ctx, content)).handle((matched, cause0) -> {
                if (cause0 != null) {
                    return RetryDecision.next();
                }
                return matched != false ? decision : RetryDecision.next();
            });
        };
        return RetryRuleUtil.orElse(first, second);
    }
}

