/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.redirect;

import com.linecorp.armeria.client.redirect.RedirectsException;
import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.internal.common.util.TemporaryThreadLocals;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.Iterables;
import java.util.Objects;

public final class CyclicRedirectsException
extends RedirectsException {
    private static final long serialVersionUID = -2969770339558298361L;

    public static CyclicRedirectsException of(String originalUri, String ... redirectUris) {
        return CyclicRedirectsException.of(originalUri, ImmutableList.copyOf(Objects.requireNonNull(redirectUris, "redirectUris")));
    }

    public static CyclicRedirectsException of(String originalUri, Iterable<String> redirectUris) {
        Objects.requireNonNull(redirectUris, "redirectUris");
        Preconditions.checkArgument(!Iterables.isEmpty(redirectUris), "redirectUris can't be empty.");
        return new CyclicRedirectsException(Objects.requireNonNull(originalUri, "originalUri"), redirectUris);
    }

    private CyclicRedirectsException(String originalUri, Iterable<String> paths) {
        super(CyclicRedirectsException.createMessage(originalUri, paths));
    }

    static String createMessage(String originalUri, Iterable<String> redirectUris) {
        try (TemporaryThreadLocals threadLocals = TemporaryThreadLocals.acquire();){
            StringBuilder sb = threadLocals.stringBuilder();
            CyclicRedirectsException.addUris(sb, originalUri, redirectUris);
            String string = sb.toString();
            return string;
        }
    }

    static void addUris(StringBuilder sb, String originalUri, Iterable<String> redirectUris) {
        sb.append("The original URI: ");
        sb.append(originalUri);
        sb.append(System.lineSeparator());
        sb.append("Redirect URIs:");
        sb.append(System.lineSeparator());
        for (String path : redirectUris) {
            sb.append('\t');
            sb.append(path);
            sb.append(System.lineSeparator());
        }
    }

    @Override
    public Throwable fillInStackTrace() {
        if (Flags.verboseExceptionSampler().isSampled(this.getClass())) {
            return super.fillInStackTrace();
        }
        return this;
    }
}

