/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.endpoint.EndpointSelectionTimeoutException;
import com.linecorp.armeria.client.endpoint.EndpointSelector;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.util.UnmodifiableFuture;
import com.linecorp.armeria.internal.client.ClientPendingThrowableUtil;
import com.linecorp.armeria.internal.common.util.IdentityHashStrategy;
import com.linecorp.armeria.internal.common.util.ReentrantShortLock;
import com.linecorp.armeria.internal.shaded.fastutil.objects.ObjectLinkedOpenCustomHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public abstract class AbstractEndpointSelector
implements EndpointSelector {
    private final EndpointGroup endpointGroup;
    private final ReentrantShortLock lock = new ReentrantShortLock();
    @GuardedBy(value="lock")
    private final Set<ListeningFuture> pendingFutures = new ObjectLinkedOpenCustomHashSet(IdentityHashStrategy.of());

    protected AbstractEndpointSelector(EndpointGroup endpointGroup) {
        this.endpointGroup = Objects.requireNonNull(endpointGroup, "endpointGroup");
    }

    protected final EndpointGroup group() {
        return this.endpointGroup;
    }

    final Set<ListeningFuture> pendingFutures() {
        return this.pendingFutures;
    }

    @Override
    @Deprecated
    public final CompletableFuture<Endpoint> select(ClientRequestContext ctx, ScheduledExecutorService executor, long timeoutMillis) {
        return this.select(ctx, executor);
    }

    @Override
    public final CompletableFuture<Endpoint> select(ClientRequestContext ctx, ScheduledExecutorService executor) {
        Endpoint endpoint0;
        Endpoint endpoint = this.selectNow(ctx);
        if (endpoint != null) {
            return UnmodifiableFuture.completedFuture(endpoint);
        }
        ListeningFuture listeningFuture = new ListeningFuture(ctx, executor);
        this.addPendingFuture(listeningFuture);
        if (listeningFuture.isDone()) {
            return listeningFuture;
        }
        if (this.endpointGroup.whenReady().isDone() && (endpoint0 = this.selectNow(ctx)) != null) {
            listeningFuture.complete(endpoint0);
            return listeningFuture;
        }
        long selectionTimeoutMillis = this.endpointGroup.selectionTimeoutMillis();
        if (selectionTimeoutMillis == 0L) {
            return UnmodifiableFuture.completedFuture(null);
        }
        if (selectionTimeoutMillis < Long.MAX_VALUE) {
            ScheduledFuture<?> timeoutFuture = executor.schedule(() -> {
                EndpointSelectionTimeoutException ex = EndpointSelectionTimeoutException.get(this.endpointGroup, selectionTimeoutMillis);
                ClientPendingThrowableUtil.setPendingThrowable(ctx, ex);
                listeningFuture.complete(null);
            }, selectionTimeoutMillis, TimeUnit.MILLISECONDS);
            listeningFuture.timeoutFuture = timeoutFuture;
            if (listeningFuture.isDone()) {
                timeoutFuture.cancel(false);
            }
        }
        return listeningFuture;
    }

    @UnstableApi
    protected final void initialize() {
        this.endpointGroup.addListener(this::refreshEndpoints, true);
    }

    private void refreshEndpoints(List<Endpoint> endpoints) {
        this.updateNewEndpoints(endpoints).handle((ignored, e) -> {
            this.lock.lock();
            try {
                this.pendingFutures.removeIf(ListeningFuture::tryComplete);
            }
            finally {
                this.lock.unlock();
            }
            return null;
        });
    }

    @UnstableApi
    protected CompletableFuture<Void> updateNewEndpoints(List<Endpoint> endpoints) {
        return UnmodifiableFuture.completedFuture(null);
    }

    private void addPendingFuture(ListeningFuture future) {
        this.lock.lock();
        try {
            this.pendingFutures.add(future);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void removePendingFuture(ListeningFuture future) {
        this.lock.lock();
        try {
            this.pendingFutures.remove(future);
        }
        finally {
            this.lock.unlock();
        }
    }

    final class ListeningFuture
    extends CompletableFuture<Endpoint> {
        private final ClientRequestContext ctx;
        private final Executor executor;
        @Nullable
        private volatile Endpoint selectedEndpoint;
        @Nullable
        private volatile ScheduledFuture<?> timeoutFuture;

        ListeningFuture(ClientRequestContext ctx, Executor executor) {
            this.ctx = ctx;
            this.executor = executor;
        }

        public boolean tryComplete() {
            if (this.selectedEndpoint != null || this.isDone()) {
                return true;
            }
            try {
                Endpoint endpoint = AbstractEndpointSelector.this.selectNow(this.ctx);
                if (endpoint == null) {
                    return false;
                }
                this.cleanup(false);
                this.selectedEndpoint = endpoint;
                this.executor.execute(() -> super.complete(endpoint));
                return true;
            }
            catch (Throwable t) {
                this.cleanup(false);
                super.completeExceptionally(t);
                return true;
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.cleanup(true);
            return super.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean complete(Endpoint value) {
            this.cleanup(true);
            return super.complete(value);
        }

        @Override
        public boolean completeExceptionally(Throwable ex) {
            this.cleanup(true);
            return super.completeExceptionally(ex);
        }

        private void cleanup(boolean removePendingFuture) {
            ScheduledFuture<?> timeoutFuture;
            if (removePendingFuture) {
                AbstractEndpointSelector.this.removePendingFuture(this);
            }
            if ((timeoutFuture = this.timeoutFuture) != null) {
                this.timeoutFuture = null;
                timeoutFuture.cancel(false);
            }
        }

        @Nullable
        ScheduledFuture<?> timeoutFuture() {
            return this.timeoutFuture;
        }
    }
}

