/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.ClientDecorationBuilder;
import com.linecorp.armeria.client.DecoratingHttpClientFunction;
import com.linecorp.armeria.client.DecoratingRpcClientFunction;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.RpcClient;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import java.util.List;
import java.util.function.Function;

public final class ClientDecoration {
    private static final ClientDecoration NONE = new ClientDecoration(ImmutableList.of(), ImmutableList.of());
    private final List<Function<? super HttpClient, ? extends HttpClient>> decorators;
    private final List<Function<? super RpcClient, ? extends RpcClient>> rpcDecorators;

    public static ClientDecoration of() {
        return NONE;
    }

    public static ClientDecoration of(Function<? super HttpClient, ? extends HttpClient> decorator) {
        return ClientDecoration.builder().add(decorator).build();
    }

    public static ClientDecoration of(DecoratingHttpClientFunction decorator) {
        return ClientDecoration.builder().add(decorator).build();
    }

    public static ClientDecoration ofRpc(Function<? super RpcClient, ? extends RpcClient> decorator) {
        return ClientDecoration.builder().addRpc(decorator).build();
    }

    public static ClientDecoration ofRpc(DecoratingRpcClientFunction decorator) {
        return ClientDecoration.builder().addRpc(decorator).build();
    }

    public static ClientDecorationBuilder builder() {
        return new ClientDecorationBuilder();
    }

    ClientDecoration(List<Function<? super HttpClient, ? extends HttpClient>> decorators, List<Function<? super RpcClient, ? extends RpcClient>> rpcDecorators) {
        this.decorators = ImmutableList.copyOf(decorators);
        this.rpcDecorators = ImmutableList.copyOf(rpcDecorators);
    }

    public List<Function<? super HttpClient, ? extends HttpClient>> decorators() {
        return this.decorators;
    }

    public List<Function<? super RpcClient, ? extends RpcClient>> rpcDecorators() {
        return this.rpcDecorators;
    }

    boolean isEmpty() {
        return this.decorators.isEmpty() && this.rpcDecorators.isEmpty();
    }

    public HttpClient decorate(HttpClient client) {
        for (Function<? super HttpClient, ? extends HttpClient> decorator : this.decorators) {
            client = decorator.apply(client);
        }
        return client;
    }

    public RpcClient rpcDecorate(RpcClient client) {
        for (Function<? super RpcClient, ? extends RpcClient> decorator : this.rpcDecorators) {
            client = decorator.apply(client);
        }
        return client;
    }
}

