/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.HttpClientFactory;
import com.linecorp.armeria.client.HttpClientPipelineConfigurator;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.handler.ssl.SslContext;
import java.lang.reflect.Array;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Set;

final class Bootstraps {
    private final Bootstrap[][] inetBootstraps;
    private final Bootstrap @Nullable [][] unixBootstraps;
    private final EventLoop eventLoop;
    private final SslContext sslCtxHttp1Only;
    private final SslContext sslCtxHttp1Or2;

    Bootstraps(HttpClientFactory clientFactory, EventLoop eventLoop, SslContext sslCtxHttp1Or2, SslContext sslCtxHttp1Only) {
        this.eventLoop = eventLoop;
        this.sslCtxHttp1Or2 = sslCtxHttp1Or2;
        this.sslCtxHttp1Only = sslCtxHttp1Only;
        Bootstrap inetBaseBootstrap = clientFactory.newInetBootstrap();
        Bootstrap unixBaseBootstrap = clientFactory.newUnixBootstrap();
        this.inetBootstraps = this.newBootstrapMap(inetBaseBootstrap, clientFactory, eventLoop);
        this.unixBootstraps = unixBaseBootstrap != null ? this.newBootstrapMap(unixBaseBootstrap, clientFactory, eventLoop) : null;
    }

    Bootstrap get(SocketAddress remoteAddress, SessionProtocol desiredProtocol, SerializationFormat serializationFormat) {
        if (!SessionProtocol.httpAndHttpsValues().contains((Object)desiredProtocol)) {
            throw new IllegalArgumentException("Unsupported session protocol: " + (Object)((Object)desiredProtocol));
        }
        if (remoteAddress instanceof InetSocketAddress) {
            return Bootstraps.select(this.inetBootstraps, desiredProtocol, serializationFormat);
        }
        assert (remoteAddress instanceof DomainSocketAddress) : remoteAddress;
        if (this.unixBootstraps == null) {
            throw new IllegalArgumentException("Domain sockets are not supported by " + this.eventLoop.getClass().getName());
        }
        return Bootstraps.select(this.unixBootstraps, desiredProtocol, serializationFormat);
    }

    private Bootstrap[][] newBootstrapMap(Bootstrap baseBootstrap, HttpClientFactory clientFactory, EventLoop eventLoop) {
        baseBootstrap.group((EventLoopGroup)eventLoop);
        Set<SessionProtocol> sessionProtocols = SessionProtocol.httpAndHttpsValues();
        Bootstrap[][] maps = (Bootstrap[][])Array.newInstance(Bootstrap.class, SessionProtocol.values().length, 2);
        for (SessionProtocol p : sessionProtocols) {
            SslContext sslCtx = this.determineSslContext(p);
            Bootstraps.setBootstrap(baseBootstrap.clone(), clientFactory, maps, p, sslCtx, true);
            Bootstraps.setBootstrap(baseBootstrap.clone(), clientFactory, maps, p, sslCtx, false);
        }
        return maps;
    }

    SslContext determineSslContext(SessionProtocol desiredProtocol) {
        return desiredProtocol.isExplicitHttp1() ? this.sslCtxHttp1Only : this.sslCtxHttp1Or2;
    }

    private static Bootstrap select(Bootstrap[][] bootstraps, SessionProtocol desiredProtocol, SerializationFormat serializationFormat) {
        return bootstraps[desiredProtocol.ordinal()][Bootstraps.toIndex(serializationFormat)];
    }

    private static void setBootstrap(Bootstrap bootstrap, final HttpClientFactory clientFactory, Bootstrap[][] maps, final SessionProtocol p, final SslContext sslCtx, final boolean webSocket) {
        bootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new HttpClientPipelineConfigurator(clientFactory, webSocket, p, sslCtx)});
            }
        });
        maps[p.ordinal()][Bootstraps.toIndex((boolean)webSocket)] = bootstrap;
    }

    private static int toIndex(boolean webSocket) {
        return webSocket ? 1 : 0;
    }

    private static int toIndex(SerializationFormat serializationFormat) {
        return Bootstraps.toIndex(serializationFormat == SerializationFormat.WS);
    }
}

