/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.AbstractRuleBuilder;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpResponseDuplicator;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.Response;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;

@UnstableApi
public abstract class AbstractRuleWithContentBuilder<SELF extends AbstractRuleWithContentBuilder<SELF, T>, T extends Response>
extends AbstractRuleBuilder<SELF> {
    @Nullable
    private BiFunction<? super ClientRequestContext, ? super T, ? extends CompletionStage<Boolean>> responseFilter;

    protected AbstractRuleWithContentBuilder(BiPredicate<? super ClientRequestContext, ? super RequestHeaders> requestHeadersFilter) {
        super(requestHeadersFilter);
    }

    public SELF onResponse(BiFunction<? super ClientRequestContext, ? super T, ? extends CompletionStage<Boolean>> responseFilter) {
        Objects.requireNonNull(responseFilter, "responseFilter");
        if (this.responseFilter == null) {
            this.responseFilter = responseFilter;
        } else {
            BiFunction first = this.responseFilter;
            this.responseFilter = (ctx, content) -> {
                if (content instanceof HttpResponse) {
                    HttpResponseDuplicator duplicator = ((HttpResponse)content).toDuplicator();
                    CompletionStage result = (CompletionStage)first.apply((ClientRequestContext)ctx, (Object)duplicator.duplicate());
                    return result.thenCompose(matched -> {
                        if (matched.booleanValue()) {
                            return result;
                        }
                        return (CompletionStage)responseFilter.apply((ClientRequestContext)ctx, (ClientRequestContext)((Object)duplicator.duplicate()));
                    }).whenComplete((unused1, unused2) -> duplicator.close());
                }
                CompletionStage result = (CompletionStage)first.apply((ClientRequestContext)ctx, (Object)content);
                return result.thenCompose(matched -> {
                    if (matched.booleanValue()) {
                        return result;
                    }
                    return (CompletionStage)responseFilter.apply((ClientRequestContext)ctx, (ClientRequestContext)content);
                });
            };
        }
        return (SELF)((AbstractRuleWithContentBuilder)this.self());
    }

    @Nullable
    protected final BiFunction<? super ClientRequestContext, ? super T, ? extends CompletionStage<Boolean>> responseFilter() {
        return this.responseFilter;
    }
}

