/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.s3.grouping;

import java.util.HashMap;
import java.util.List;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.plugins.sink.s3.KeyGenerator;
import org.opensearch.dataprepper.plugins.sink.s3.S3BucketSelector;
import org.opensearch.dataprepper.plugins.sink.s3.S3SinkConfig;
import org.opensearch.dataprepper.plugins.sink.s3.grouping.S3GroupIdentifier;

public class S3GroupIdentifierFactory {
    private final KeyGenerator keyGenerator;
    private final List<String> dynamicEventsKeys;
    private final List<String> dynamicExpressions;
    private final ExpressionEvaluator expressionEvaluator;
    private final S3SinkConfig s3SinkConfig;
    private final S3BucketSelector s3BucketSelector;
    private static final String BUCKET_NAME_REPLACEMENT_FOR_NON_EXISTING_KEYS = "";

    public S3GroupIdentifierFactory(KeyGenerator keyGenerator, ExpressionEvaluator expressionEvaluator, S3SinkConfig s3SinkConfig, S3BucketSelector s3BucketSelector) {
        this.keyGenerator = keyGenerator;
        this.expressionEvaluator = expressionEvaluator;
        this.s3SinkConfig = s3SinkConfig;
        this.s3BucketSelector = s3BucketSelector;
        this.dynamicExpressions = expressionEvaluator.extractDynamicExpressionsFromFormatExpression(s3SinkConfig.getObjectKeyOptions().getPathPrefix());
        this.dynamicExpressions.addAll(expressionEvaluator.extractDynamicExpressionsFromFormatExpression(s3SinkConfig.getObjectKeyOptions().getNamePattern()));
        if (s3BucketSelector == null) {
            this.dynamicExpressions.addAll(expressionEvaluator.extractDynamicExpressionsFromFormatExpression(s3SinkConfig.getBucketName()));
        }
        this.dynamicEventsKeys = expressionEvaluator.extractDynamicKeysFromFormatExpression(s3SinkConfig.getObjectKeyOptions().getPathPrefix());
        this.dynamicEventsKeys.addAll(expressionEvaluator.extractDynamicKeysFromFormatExpression(s3SinkConfig.getObjectKeyOptions().getNamePattern()));
        if (s3BucketSelector == null) {
            this.dynamicEventsKeys.addAll(expressionEvaluator.extractDynamicKeysFromFormatExpression(s3SinkConfig.getBucketName()));
        }
    }

    public S3GroupIdentifier getS3GroupIdentifierForEvent(Event event) {
        Object value;
        String fullObjectKey = this.keyGenerator.generateKeyForEvent(event);
        String fullBucketName = this.s3BucketSelector != null ? this.s3BucketSelector.getBucketName() : event.formatString(this.s3SinkConfig.getBucketName(), this.expressionEvaluator, BUCKET_NAME_REPLACEMENT_FOR_NON_EXISTING_KEYS);
        HashMap<String, Object> groupIdentificationHash = new HashMap<String, Object>();
        for (String key : this.dynamicEventsKeys) {
            value = event.get(key, Object.class);
            groupIdentificationHash.put(key, value);
        }
        for (String expression : this.dynamicExpressions) {
            value = this.expressionEvaluator.evaluate(expression, event);
            groupIdentificationHash.put(expression, value);
        }
        return new S3GroupIdentifier(groupIdentificationHash, fullObjectKey, this.s3SinkConfig.getObjectMetadataConfig(), fullBucketName);
    }
}

