/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.s3.accumulator;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.time.StopWatch;
import org.opensearch.dataprepper.plugins.sink.s3.accumulator.Buffer;
import org.opensearch.dataprepper.plugins.sink.s3.accumulator.BufferUtilities;
import org.opensearch.dataprepper.plugins.sink.s3.accumulator.ByteArrayPositionOutputStream;
import org.opensearch.dataprepper.plugins.sink.s3.ownership.BucketOwnerProvider;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.services.s3.S3AsyncClient;

public class InMemoryBuffer
implements Buffer {
    private final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    private final ByteArrayPositionOutputStream byteArrayPositionOutputStream = new ByteArrayPositionOutputStream(this.byteArrayOutputStream);
    private final S3AsyncClient s3Client;
    private final Supplier<String> bucketSupplier;
    private final Supplier<String> keySupplier;
    private final Function<Integer, Map<String, String>> metadataSupplier;
    private final BucketOwnerProvider bucketOwnerProvider;
    private int eventCount;
    private final StopWatch watch;
    private boolean isCodecStarted;
    private String bucket;
    private String key;
    private String defaultBucket;

    InMemoryBuffer(S3AsyncClient s3Client, Supplier<String> bucketSupplier, Supplier<String> keySupplier, Function<Integer, Map<String, String>> metadataSupplier, String defaultBucket, BucketOwnerProvider bucketOwnerProvider) {
        this.s3Client = s3Client;
        this.bucketSupplier = bucketSupplier;
        this.keySupplier = keySupplier;
        this.metadataSupplier = metadataSupplier;
        this.byteArrayOutputStream.reset();
        this.eventCount = 0;
        this.watch = new StopWatch();
        this.watch.start();
        this.isCodecStarted = false;
        this.defaultBucket = defaultBucket;
        this.bucketOwnerProvider = bucketOwnerProvider;
    }

    @Override
    public long getSize() {
        return this.byteArrayOutputStream.size();
    }

    @Override
    public int getEventCount() {
        return this.eventCount;
    }

    @Override
    public Duration getDuration() {
        return Duration.ofMillis(this.watch.getTime(TimeUnit.MILLISECONDS));
    }

    @Override
    public Optional<CompletableFuture<?>> flushToS3(Consumer<Boolean> consumeOnCompletion, Consumer<Throwable> consumeOnException) {
        byte[] byteArray = this.byteArrayOutputStream.toByteArray();
        return Optional.ofNullable(BufferUtilities.putObjectOrSendToDefaultBucket(this.s3Client, AsyncRequestBody.fromBytes((byte[])byteArray), consumeOnCompletion, consumeOnException, this.getKey(), this.getBucket(), this.defaultBucket, this.getMetadata(this.getEventCount()), this.bucketOwnerProvider));
    }

    private String getBucket() {
        if (this.bucket == null) {
            this.bucket = this.bucketSupplier.get();
        }
        return this.bucket;
    }

    private Map<String, String> getMetadata(int eventCount) {
        if (this.metadataSupplier != null) {
            return this.metadataSupplier.apply(this.getEventCount());
        }
        return null;
    }

    @Override
    public void setEventCount(int eventCount) {
        this.eventCount = eventCount;
    }

    @Override
    public String getKey() {
        if (this.key == null) {
            this.key = this.keySupplier.get();
        }
        return this.key;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.byteArrayPositionOutputStream;
    }
}

