/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.s3.accumulator;

import java.io.OutputStream;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.opensearch.dataprepper.plugins.sink.s3.accumulator.Buffer;
import org.opensearch.dataprepper.plugins.sink.s3.codec.BufferedCodec;

public class CodecBuffer
implements Buffer {
    private final Buffer innerBuffer;
    private final BufferedCodec bufferedCodec;

    public CodecBuffer(Buffer innerBuffer, BufferedCodec bufferedCodec) {
        this.innerBuffer = innerBuffer;
        this.bufferedCodec = bufferedCodec;
    }

    @Override
    public long getSize() {
        return this.bufferedCodec.getSize().orElseGet(this.innerBuffer::getSize);
    }

    @Override
    public int getEventCount() {
        return this.innerBuffer.getEventCount();
    }

    @Override
    public Duration getDuration() {
        return this.innerBuffer.getDuration();
    }

    @Override
    public Optional<CompletableFuture<?>> flushToS3(Consumer<Boolean> runOnCompletion, Consumer<Throwable> runOnException) {
        return this.innerBuffer.flushToS3(runOnCompletion, runOnException);
    }

    @Override
    public OutputStream getOutputStream() {
        return this.innerBuffer.getOutputStream();
    }

    @Override
    public void setEventCount(int eventCount) {
        this.innerBuffer.setEventCount(eventCount);
    }

    @Override
    public String getKey() {
        return this.innerBuffer.getKey();
    }
}

