/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.s3;

import java.time.LocalDate;
import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.plugins.sink.s3.S3BucketSelector;
import org.opensearch.dataprepper.plugins.sink.s3.S3SinkConfig;
import org.opensearch.dataprepper.plugins.sink.s3.SecurityLakeBucketSelectorConfig;
import software.amazon.awssdk.services.securitylake.SecurityLakeClient;
import software.amazon.awssdk.services.securitylake.model.AwsIdentity;
import software.amazon.awssdk.services.securitylake.model.CreateCustomLogSourceRequest;
import software.amazon.awssdk.services.securitylake.model.CreateCustomLogSourceResponse;
import software.amazon.awssdk.services.securitylake.model.CustomLogSourceConfiguration;
import software.amazon.awssdk.services.securitylake.model.CustomLogSourceCrawlerConfiguration;
import software.amazon.awssdk.services.securitylake.model.CustomLogSourceProvider;

@DataPrepperPlugin(name="aws_security_lake", pluginType=S3BucketSelector.class, pluginConfigurationType=SecurityLakeBucketSelectorConfig.class)
public class SecurityLakeBucketSelector
implements S3BucketSelector {
    private static final String EXT_PATH = "/ext/";
    private final SecurityLakeBucketSelectorConfig securityLakeBucketSelectorConfig;
    private S3SinkConfig s3SinkConfig;
    private String pathPrefix;
    private String sourceLocation;

    @DataPrepperPluginConstructor
    public SecurityLakeBucketSelector(SecurityLakeBucketSelectorConfig securityLakeBucketSelectorConfig) {
        this.securityLakeBucketSelectorConfig = securityLakeBucketSelectorConfig;
    }

    @Override
    public void initialize(S3SinkConfig s3SinkConfig) {
        this.s3SinkConfig = s3SinkConfig;
        SecurityLakeClient securityLakeClient = SecurityLakeClient.create();
        String arn = s3SinkConfig.getAwsAuthenticationOptions().getAwsStsRoleArn();
        String principal = arn.split(":")[4];
        String sourceName = this.securityLakeBucketSelectorConfig.getSourceName() != null ? this.securityLakeBucketSelectorConfig.getSourceName() : RandomStringUtils.randomAlphabetic((int)7);
        CreateCustomLogSourceResponse response = securityLakeClient.createCustomLogSource((CreateCustomLogSourceRequest)CreateCustomLogSourceRequest.builder().sourceName(sourceName + RandomStringUtils.randomAlphabetic((int)4)).eventClasses(List.of(this.securityLakeBucketSelectorConfig.getLogClass())).sourceVersion(this.securityLakeBucketSelectorConfig.getSourceVersion()).configuration((CustomLogSourceConfiguration)CustomLogSourceConfiguration.builder().crawlerConfiguration((CustomLogSourceCrawlerConfiguration)CustomLogSourceCrawlerConfiguration.builder().roleArn(arn).build()).providerIdentity((AwsIdentity)AwsIdentity.builder().externalId(this.securityLakeBucketSelectorConfig.getExternalId()).principal(principal).build()).build()).build());
        CustomLogSourceProvider provider = response.source().provider();
        this.sourceLocation = provider.location();
        String region = s3SinkConfig.getAwsAuthenticationOptions().getAwsRegion().toString();
        String accountId = arn.split(":")[4];
        LocalDate now = LocalDate.now();
        String eventDay = String.format("%d%02d%02d", now.getYear(), now.getMonthValue(), now.getDayOfMonth());
        int locIndex = this.sourceLocation.indexOf(EXT_PATH);
        this.pathPrefix = String.format("%sregion=%s/accountId=%s/eventDay=%s/", this.sourceLocation.substring(locIndex + 1), region, accountId, eventDay);
    }

    @Override
    public String getPathPrefix() {
        return this.pathPrefix;
    }

    @Override
    public String getBucketName() {
        int locIndex = this.sourceLocation.indexOf(EXT_PATH);
        return this.sourceLocation.substring(EXT_PATH.length(), locIndex);
    }
}

