/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.s3;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Map;
import org.opensearch.dataprepper.aws.validator.AwsAccountId;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.plugins.sink.s3.ObjectMetadataConfig;
import org.opensearch.dataprepper.plugins.sink.s3.PredefinedObjectMetadata;
import org.opensearch.dataprepper.plugins.sink.s3.accumulator.BufferTypeOptions;
import org.opensearch.dataprepper.plugins.sink.s3.compression.CompressionOption;
import org.opensearch.dataprepper.plugins.sink.s3.configuration.AggregateThresholdOptions;
import org.opensearch.dataprepper.plugins.sink.s3.configuration.AwsAuthenticationOptions;
import org.opensearch.dataprepper.plugins.sink.s3.configuration.ClientOptions;
import org.opensearch.dataprepper.plugins.sink.s3.configuration.ObjectKeyOptions;
import org.opensearch.dataprepper.plugins.sink.s3.configuration.ThresholdOptions;

public class S3SinkConfig {
    static final String S3_PREFIX = "s3://";
    private static final int DEFAULT_CONNECTION_RETRIES = 5;
    private static final int DEFAULT_UPLOAD_RETRIES = 5;
    @JsonProperty(value="aws")
    @NotNull
    @Valid
    private AwsAuthenticationOptions awsAuthenticationOptions;
    @JsonProperty(value="bucket")
    @Size(min=3, max=500, message="bucket length should be at least 3 characters")
    private @Size(min=3, max=500, message="bucket length should be at least 3 characters") String bucketName;
    @JsonProperty(value="bucket_selector")
    private PluginModel bucketSelector;
    @JsonProperty(value="predefined_object_metadata")
    private PredefinedObjectMetadata predefinedObjectMetadata;
    @JsonProperty(value="object_metadata")
    private ObjectMetadataConfig objectMetadataConfig;
    @JsonProperty(value="default_bucket")
    @Size(min=3, max=500, message="default_bucket length should be at least 3 characters")
    private @Size(min=3, max=500, message="default_bucket length should be at least 3 characters") String defaultBucket;
    @JsonProperty(value="object_key")
    @Valid
    private ObjectKeyOptions objectKeyOptions = new ObjectKeyOptions();
    @JsonProperty(value="compression")
    private CompressionOption compression = CompressionOption.NONE;
    @JsonProperty(value="threshold")
    @NotNull
    @Valid
    private ThresholdOptions thresholdOptions;
    @JsonProperty(value="aggregate_threshold")
    @Valid
    private AggregateThresholdOptions aggregateThresholdOptions;
    @JsonProperty(value="codec")
    @NotNull
    private PluginModel codec;
    @JsonProperty(value="buffer_type")
    private BufferTypeOptions bufferType = BufferTypeOptions.INMEMORY;
    private int maxConnectionRetries = 5;
    @JsonProperty(value="max_retries")
    private int maxUploadRetries = 5;
    @JsonProperty(value="bucket_owners")
    private Map<String, @AwsAccountId String> bucketOwners;
    @JsonProperty(value="default_bucket_owner")
    @AwsAccountId
    private String defaultBucketOwner;
    @JsonProperty(value="client")
    private ClientOptions clientOptions;

    @AssertTrue(message="Only one of object_metadata and predefined_object_metadata can be used.")
    @AssertTrue(message="Only one of object_metadata and predefined_object_metadata can be used.") boolean isValidMetadataConfig() {
        return this.objectMetadataConfig == null || this.predefinedObjectMetadata == null;
    }

    @AssertTrue(message="You may not use both bucket and bucket_selector together in one S3 sink.")
    private @AssertTrue(message="You may not use both bucket and bucket_selector together in one S3 sink.") boolean isValidBucketConfig() {
        return this.bucketName != null && this.bucketSelector == null || this.bucketName == null && this.bucketSelector != null;
    }

    public AwsAuthenticationOptions getAwsAuthenticationOptions() {
        return this.awsAuthenticationOptions;
    }

    public ThresholdOptions getThresholdOptions() {
        return this.thresholdOptions;
    }

    public AggregateThresholdOptions getAggregateThresholdOptions() {
        return this.aggregateThresholdOptions;
    }

    public String getBucketName() {
        if (this.bucketName.startsWith(S3_PREFIX)) {
            return this.bucketName.substring(S3_PREFIX.length());
        }
        return this.bucketName;
    }

    public ObjectKeyOptions getObjectKeyOptions() {
        if (this.objectKeyOptions == null) {
            this.objectKeyOptions = new ObjectKeyOptions();
        }
        return this.objectKeyOptions;
    }

    public Object getObjectMetadataConfig() {
        return this.objectMetadataConfig != null ? this.objectMetadataConfig : this.predefinedObjectMetadata;
    }

    public PluginModel getBucketSelector() {
        return this.bucketSelector;
    }

    public PluginModel getCodec() {
        return this.codec;
    }

    public BufferTypeOptions getBufferType() {
        return this.bufferType;
    }

    public int getMaxConnectionRetries() {
        return this.maxConnectionRetries;
    }

    public int getMaxUploadRetries() {
        return this.maxUploadRetries;
    }

    public CompressionOption getCompression() {
        return this.compression;
    }

    public String getDefaultBucket() {
        return this.defaultBucket;
    }

    public Map<String, String> getBucketOwners() {
        return this.bucketOwners;
    }

    public String getDefaultBucketOwner() {
        return this.defaultBucketOwner;
    }

    public ClientOptions getClientOptions() {
        return this.clientOptions;
    }
}

