/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.logstash.model;

import com.google.common.base.Preconditions;
import java.util.List;
import org.opensearch.dataprepper.logstash.model.LogstashAttribute;

public class LogstashPlugin {
    private final String pluginName;
    private final List<LogstashAttribute> attributes;

    public String getPluginName() {
        return this.pluginName;
    }

    public List<LogstashAttribute> getAttributes() {
        return this.attributes;
    }

    private LogstashPlugin(Builder builder) {
        Preconditions.checkNotNull((Object)builder.pluginName, (Object)"plugin name cannot be null");
        Preconditions.checkNotNull(builder.attributes, (Object)"attributes cannot be null");
        this.pluginName = builder.pluginName;
        this.attributes = builder.attributes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String pluginName;
        private List<LogstashAttribute> attributes;

        public Builder pluginName(String pluginName) {
            this.pluginName = pluginName;
            return this;
        }

        public Builder attributes(List<LogstashAttribute> attributes) {
            this.attributes = attributes;
            return this;
        }

        public LogstashPlugin build() {
            return new LogstashPlugin(this);
        }
    }
}

