/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.logstash.model;

import com.google.common.base.Preconditions;
import org.opensearch.dataprepper.logstash.model.LogstashValueType;

public class LogstashAttributeValue {
    private final LogstashValueType attributeValueType;
    private final Object value;

    public LogstashValueType getAttributeValueType() {
        return this.attributeValueType;
    }

    public Object getValue() {
        return this.value;
    }

    private LogstashAttributeValue(Builder builder) {
        Preconditions.checkNotNull((Object)((Object)builder.attributeValueType), (Object)"attribute value type cannot be null");
        Preconditions.checkNotNull((Object)builder.value, (Object)"attribute value cannot be null");
        this.attributeValueType = builder.attributeValueType;
        this.value = builder.value;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private LogstashValueType attributeValueType;
        private Object value;

        public Builder attributeValueType(LogstashValueType attributeValueType) {
            this.attributeValueType = attributeValueType;
            return this;
        }

        public Builder value(Object value) {
            this.value = value;
            return this;
        }

        public LogstashAttributeValue build() {
            return new LogstashAttributeValue(this);
        }
    }
}

