/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.logstash.mapping;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.dataprepper.logstash.mapping.NestedSyntaxConverter;

class GrokNamedCapturesUtil {
    private static final String namedCapturesRegex = "\\(\\?\\<(.+?)\\>(.+?)\\)";
    private static final Pattern namedCapturesPattern = Pattern.compile("\\(\\?\\<(.+?)\\>(.+?)\\)");
    private static final int PATTERN_NAME_LENGTH = 8;

    GrokNamedCapturesUtil() {
    }

    static GrokNamedCapturesPair convertRegexNamedCapturesToGrokPatternDefinitions(String regexPattern) {
        Objects.requireNonNull(regexPattern);
        Matcher matcher = namedCapturesPattern.matcher(regexPattern);
        LinkedHashMap<String, String> mappedPatternDefinitions = new LinkedHashMap<String, String>();
        while (matcher.find()) {
            String patternRegex = matcher.group(2);
            String captureName = NestedSyntaxConverter.convertNestedSyntaxToJsonPointer(matcher.group(1));
            String patternName = GrokNamedCapturesUtil.generateRandomPatternName();
            String replacementPattern = String.format("%%{%s:%s}", patternName, captureName);
            regexPattern = StringUtils.replaceOnce((String)regexPattern, (String)matcher.group(0), (String)replacementPattern);
            mappedPatternDefinitions.put(patternName, patternRegex);
        }
        return new GrokNamedCapturesPair(regexPattern, mappedPatternDefinitions);
    }

    private static String generateRandomPatternName() {
        return RandomStringUtils.random((int)8, (boolean)true, (boolean)true);
    }

    static class GrokNamedCapturesPair {
        private final String mappedRegex;
        private final Map<String, String> mappedPatternDefinitions;

        public GrokNamedCapturesPair(String mappedRegex, Map<String, String> mappedPatternDefinitions) {
            this.mappedRegex = mappedRegex;
            this.mappedPatternDefinitions = mappedPatternDefinitions;
        }

        public String getMappedRegex() {
            return this.mappedRegex;
        }

        public Map<String, String> getMappedPatternDefinitions() {
            return Collections.unmodifiableMap(this.mappedPatternDefinitions);
        }
    }
}

