/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.otlp.metrics;

import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import javax.annotation.Nonnull;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.configuration.PluginSetting;

public class OtlpSinkMetrics {
    private final PluginMetrics pluginMetrics;
    private final Timer httpLatency;
    private final DistributionSummary payloadSize;
    private final DistributionSummary payloadGzipSize;

    public OtlpSinkMetrics(@Nonnull PluginMetrics pluginMetrics, @Nonnull PluginSetting pluginSetting) {
        this.pluginMetrics = pluginMetrics;
        String pipelineName = pluginSetting.getPipelineName();
        String pluginName = pluginSetting.getName();
        this.httpLatency = OtlpSinkMetrics.buildLatencyTimer(pipelineName, pluginName, "httpLatency");
        this.payloadSize = OtlpSinkMetrics.buildDistributionSummary(pipelineName, pluginName, "payloadSize");
        this.payloadGzipSize = OtlpSinkMetrics.buildDistributionSummary(pipelineName, pluginName, "payloadGzipSize");
    }

    private static Timer buildLatencyTimer(@Nonnull String pipelineName, @Nonnull String pluginName, @Nonnull String metricName) {
        return Timer.builder((String)String.format("%s_%s_%s", pipelineName, pluginName, metricName)).publishPercentiles(new double[]{0.5, 0.9, 0.95, 0.99, 1.0}).publishPercentileHistogram(Boolean.valueOf(true)).distributionStatisticBufferLength(Integer.valueOf(1024)).distributionStatisticExpiry(Duration.ofMinutes(10L)).register((MeterRegistry)Metrics.globalRegistry);
    }

    private static DistributionSummary buildDistributionSummary(@Nonnull String pipelineName, @Nonnull String pluginName, @Nonnull String metricName) {
        return DistributionSummary.builder((String)String.format("%s_%s_%s", pipelineName, pluginName, metricName)).baseUnit("bytes").publishPercentiles(new double[]{0.5, 0.9, 0.95, 0.99, 1.0}).publishPercentileHistogram(Boolean.valueOf(true)).distributionStatisticBufferLength(Integer.valueOf(1024)).distributionStatisticExpiry(Duration.ofMinutes(10L)).register((MeterRegistry)Metrics.globalRegistry);
    }

    public void incrementRecordsOut(long count) {
        this.pluginMetrics.counter("recordsOut").increment((double)count);
    }

    public void incrementErrorsCount() {
        this.pluginMetrics.counter("errorsCount").increment(1.0);
    }

    public void incrementPayloadSize(long bytes) {
        this.payloadSize.record((double)bytes);
    }

    public void incrementPayloadGzipSize(long bytes) {
        this.payloadGzipSize.record((double)bytes);
    }

    public void recordHttpLatency(long durationMillis) {
        this.httpLatency.record(Duration.ofMillis(durationMillis));
    }

    public void registerQueueGauges(BlockingQueue<?> queue) {
        this.pluginMetrics.gauge("queueSize", queue, Collection::size);
        this.pluginMetrics.gauge("queueCapacity", queue, q -> q.remainingCapacity() + q.size());
    }

    public void incrementRejectedSpansCount(long count) {
        this.pluginMetrics.counter("rejectedSpansCount").increment((double)count);
    }

    public void incrementFailedSpansCount(long count) {
        this.pluginMetrics.counter("failedSpansCount").increment((double)count);
    }

    public void recordResponseCode(int statusCode) {
        String codeCategory = statusCode / 100 + "xx";
        this.pluginMetrics.counter("http_" + codeCategory + "_responses").increment();
    }
}

