/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.otlp.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import java.net.URI;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.aws.api.AwsConfig;
import org.opensearch.dataprepper.plugins.sink.otlp.configuration.ThresholdConfig;
import software.amazon.awssdk.regions.Region;

public class OtlpSinkConfig {
    @JsonProperty(value="endpoint")
    @NotBlank(message="endpoint is required")
    private @NotBlank(message="endpoint is required") String endpoint;
    @JsonProperty(value="max_retries")
    @Min(value=0L)
    private @Min(value=0L) int maxRetries = 5;
    @JsonProperty(value="threshold")
    @Valid
    private ThresholdConfig thresholdConfig = new ThresholdConfig();
    @JsonProperty(value="aws")
    @Valid
    private AwsConfig awsConfig;

    public int getMaxEvents() {
        return this.thresholdConfig.getMaxEvents();
    }

    public long getMaxBatchSize() {
        return this.thresholdConfig.getMaxBatchSize().getBytes();
    }

    public long getFlushTimeoutMillis() {
        return this.thresholdConfig.getFlushTimeout().toMillis();
    }

    public Region getAwsRegion() {
        try {
            String host = URI.create(this.endpoint).getHost();
            if (host == null) {
                throw new IllegalArgumentException();
            }
            Set knownRegions = Region.regions().stream().map(Region::id).collect(Collectors.toSet());
            return Arrays.stream(host.split("\\.")).filter(knownRegions::contains).map(Region::of).findFirst().orElseThrow(() -> new IllegalArgumentException("No valid AWS region found in endpoint: " + this.endpoint));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse AWS region from endpoint: " + this.endpoint, e);
        }
    }

    public String getStsRoleArn() {
        if (this.awsConfig == null || this.awsConfig.getAwsStsRoleArn() == null) {
            return null;
        }
        return this.awsConfig.getAwsStsRoleArn();
    }

    public String getStsExternalId() {
        if (this.awsConfig == null || this.awsConfig.getAwsStsExternalId() == null) {
            return null;
        }
        return this.awsConfig.getAwsStsExternalId();
    }

    @AssertTrue
    boolean isAwsConfigValid() {
        return this.awsConfig != null;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }
}

