/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.lambda.common.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.Duration;
import org.hibernate.validator.constraints.time.DurationMax;
import org.hibernate.validator.constraints.time.DurationMin;
import org.opensearch.dataprepper.model.types.ByteCount;

public class ThresholdOptions {
    public static final int DEFAULT_EVENT_COUNT = 100;
    public static final String DEFAULT_BYTE_CAPACITY = "5mb";
    public static final Duration DEFAULT_EVENT_TIMEOUT = Duration.ofSeconds(10L);
    @JsonProperty(value="event_count")
    @Size(min=0, max=10000000, message="event_count size should be between 0 and 10000000")
    @NotNull
    private @Size(min=0, max=10000000, message="event_count size should be between 0 and 10000000") @NotNull int eventCount = 100;
    @JsonProperty(value="maximum_size")
    private String maximumSize = "5mb";
    @JsonProperty(value="event_collect_timeout")
    @DurationMin(seconds=1L)
    @DurationMax(seconds=3600L)
    @NotNull
    private @DurationMin(seconds=1L) @DurationMax(seconds=3600L) @NotNull Duration eventCollectTimeOut = DEFAULT_EVENT_TIMEOUT;

    public Duration getEventCollectTimeOut() {
        return this.eventCollectTimeOut;
    }

    public ByteCount getMaximumSize() {
        return ByteCount.parse((String)this.maximumSize);
    }

    public int getEventCount() {
        return this.eventCount;
    }
}

