/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.encryption;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.plugins.encryption.EncryptedDataKeySupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalDirectoryEncryptedDataKeySupplier
implements EncryptedDataKeySupplier {
    private static final Logger LOG = LoggerFactory.getLogger(LocalDirectoryEncryptedDataKeySupplier.class);
    private final Path encryptionKeyDirectory;
    private final AtomicReference<String> encryptedDataKey = new AtomicReference();

    public LocalDirectoryEncryptedDataKeySupplier(String encryptionKeyDirectory) {
        this.encryptionKeyDirectory = Paths.get(encryptionKeyDirectory, new String[0]);
        this.encryptedDataKey.set(this.retrieveLatestFileContent());
    }

    @Override
    public String retrieveValue() {
        return this.encryptedDataKey.get();
    }

    @Override
    public void refresh() {
        this.encryptedDataKey.set(this.retrieveLatestFileContent());
    }

    private String retrieveLatestFileContent() {
        Path latestFile = this.retrieveLatestFileKey();
        try {
            LOG.info("Reading latest key file: {}", (Object)latestFile);
            return Files.readString(latestFile, StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            LOG.error("Error reading key file: {}", (Object)latestFile, (Object)ex);
            throw new RuntimeException(ex);
        }
    }

    private Path retrieveLatestFileKey() {
        try {
            List keyFiles = Files.list(this.encryptionKeyDirectory).filter(path -> path.toString().endsWith(".key")).sorted(Comparator.comparing(Path::getFileName).reversed()).collect(Collectors.toList());
            if (keyFiles.isEmpty()) {
                throw new IllegalStateException("No data key files found in " + String.valueOf(this.encryptionKeyDirectory));
            }
            return (Path)keyFiles.get(0);
        }
        catch (IOException ex) {
            LOG.error("Error accessing encryption key directory: {}", (Object)this.encryptionKeyDirectory, (Object)ex);
            throw new RuntimeException(ex);
        }
    }
}

