/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.source;

import com.amazonaws.services.schemaregistry.deserializers.GlueSchemaRegistryKafkaDeserializer;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import io.confluent.kafka.serializers.json.KafkaJsonSchemaDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.BrokerNotAvailableException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.connect.json.JsonDeserializer;
import org.opensearch.dataprepper.aws.api.AwsCredentialsSupplier;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSetManager;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.configuration.PipelineDescription;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.plugin.PluginConfigObservable;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.source.Source;
import org.opensearch.dataprepper.plugins.kafka.common.aws.AwsContext;
import org.opensearch.dataprepper.plugins.kafka.common.thread.KafkaPluginThreadFactory;
import org.opensearch.dataprepper.plugins.kafka.configuration.AuthConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.OAuthConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.PlainTextAuthConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.SchemaConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.SchemaRegistryType;
import org.opensearch.dataprepper.plugins.kafka.configuration.TopicConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.TopicConsumerConfig;
import org.opensearch.dataprepper.plugins.kafka.consumer.KafkaCustomConsumer;
import org.opensearch.dataprepper.plugins.kafka.consumer.KafkaCustomConsumerFactory;
import org.opensearch.dataprepper.plugins.kafka.consumer.PauseConsumePredicate;
import org.opensearch.dataprepper.plugins.kafka.extension.KafkaClusterConfigSupplier;
import org.opensearch.dataprepper.plugins.kafka.source.KafkaSourceConfig;
import org.opensearch.dataprepper.plugins.kafka.util.ClientDNSLookupType;
import org.opensearch.dataprepper.plugins.kafka.util.KafkaSecurityConfigurer;
import org.opensearch.dataprepper.plugins.kafka.util.KafkaTopicConsumerMetrics;
import org.opensearch.dataprepper.plugins.kafka.util.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@DataPrepperPlugin(name="kafka", pluginType=Source.class, pluginConfigurationType=KafkaSourceConfig.class)
public class KafkaSource
implements Source<Record<Event>> {
    private static final String NO_RESOLVABLE_URLS_ERROR_MESSAGE = "No resolvable bootstrap urls given in bootstrap.servers";
    private static final long RETRY_SLEEP_INTERVAL = 30000L;
    private static final String MDC_KAFKA_PLUGIN_VALUE = "source";
    private static final Logger LOG = LoggerFactory.getLogger(KafkaSource.class);
    private final KafkaSourceConfig sourceConfig;
    private final AtomicBoolean shutdownInProgress;
    private final PluginMetrics pluginMetrics;
    private KafkaCustomConsumer consumer;
    private KafkaConsumer kafkaConsumer;
    private final String pipelineName;
    private String consumerGroupID;
    private String schemaType = MessageFormat.PLAINTEXT.toString();
    private final AcknowledgementSetManager acknowledgementSetManager;
    private static CachedSchemaRegistryClient schemaRegistryClient;
    private GlueSchemaRegistryKafkaDeserializer glueDeserializer;
    private StringDeserializer stringDeserializer;
    private final List<ExecutorService> allTopicExecutorServices;
    private final List<KafkaCustomConsumer> allTopicConsumers;
    private final PluginConfigObservable pluginConfigObservable;
    private final AwsCredentialsSupplier awsCredentialsSupplier;

    @DataPrepperPluginConstructor
    public KafkaSource(KafkaSourceConfig sourceConfig, PluginMetrics pluginMetrics, AcknowledgementSetManager acknowledgementSetManager, PipelineDescription pipelineDescription, KafkaClusterConfigSupplier kafkaClusterConfigSupplier, PluginConfigObservable pluginConfigObservable, AwsCredentialsSupplier awsCredentialsSupplier) {
        this.sourceConfig = sourceConfig;
        this.pluginMetrics = pluginMetrics;
        this.acknowledgementSetManager = acknowledgementSetManager;
        this.pipelineName = pipelineDescription.getPipelineName();
        this.stringDeserializer = new StringDeserializer();
        this.shutdownInProgress = new AtomicBoolean(false);
        this.allTopicExecutorServices = new ArrayList<ExecutorService>();
        this.allTopicConsumers = new ArrayList<KafkaCustomConsumer>();
        this.pluginConfigObservable = pluginConfigObservable;
        this.awsCredentialsSupplier = awsCredentialsSupplier;
        this.updateConfig(kafkaClusterConfigSupplier);
    }

    public boolean areAcknowledgementsEnabled() {
        return this.sourceConfig.getAcknowledgementsEnabled();
    }

    public void start(Buffer<Record<Event>> buffer) {
        try {
            KafkaSource.setMdc();
            Properties authProperties = new Properties();
            KafkaSecurityConfigurer.setDynamicSaslClientCallbackHandler(authProperties, this.sourceConfig, this.pluginConfigObservable);
            KafkaSecurityConfigurer.setAuthProperties(authProperties, this.sourceConfig, LOG);
            this.sourceConfig.getTopics().forEach(topic -> {
                this.consumerGroupID = topic.getGroupId();
                KafkaTopicConsumerMetrics topicMetrics = new KafkaTopicConsumerMetrics(topic.getName(), this.pluginMetrics, true);
                Properties consumerProperties = this.getConsumerProperties((TopicConsumerConfig)topic, authProperties);
                MessageFormat schema = MessageFormat.getByMessageFormatByName(this.schemaType);
                try {
                    int numWorkers = topic.getWorkers();
                    ExecutorService executorService = Executors.newFixedThreadPool(numWorkers, KafkaPluginThreadFactory.defaultExecutorThreadFactory(MDC_KAFKA_PLUGIN_VALUE, topic.getName()));
                    this.allTopicExecutorServices.add(executorService);
                    IntStream.range(0, numWorkers).forEach(index -> {
                        while (true) {
                            try {
                                this.kafkaConsumer = this.createKafkaConsumer(schema, consumerProperties);
                            }
                            catch (ConfigException ce) {
                                if (ce.getMessage().contains(NO_RESOLVABLE_URLS_ERROR_MESSAGE)) {
                                    LOG.warn("Exception while creating Kafka consumer: ", (Throwable)ce);
                                    LOG.warn("Bootstrap URL could not be resolved. Retrying in {} ms...", (Object)30000L);
                                    try {
                                        this.sleep(30000L);
                                    }
                                    catch (InterruptedException ie) {
                                        Thread.currentThread().interrupt();
                                        throw new RuntimeException(ie);
                                    }
                                    continue;
                                }
                                throw ce;
                            }
                            break;
                        }
                        this.consumer = new KafkaCustomConsumer(this.kafkaConsumer, this.shutdownInProgress, buffer, this.sourceConfig, (TopicConsumerConfig)topic, this.schemaType, this.acknowledgementSetManager, null, topicMetrics, PauseConsumePredicate.noPause());
                        this.allTopicConsumers.add(this.consumer);
                        executorService.submit(this.consumer);
                    });
                }
                catch (Exception e) {
                    if (e instanceof BrokerNotAvailableException || e instanceof TimeoutException) {
                        LOG.error("The kafka broker is not available...");
                    } else {
                        LOG.error("Failed to setup the Kafka Source Plugin.", (Throwable)e);
                    }
                    throw new RuntimeException(e);
                }
                LOG.info("Started Kafka source for topic " + topic.getName());
            });
        }
        finally {
            KafkaSource.removeMdc();
        }
    }

    KafkaConsumer<?, ?> createKafkaConsumer(MessageFormat schema, Properties consumerProperties) {
        switch (schema) {
            case JSON: {
                return new KafkaConsumer(consumerProperties);
            }
            case AVRO: {
                return new KafkaConsumer(consumerProperties);
            }
        }
        AwsContext awsContext = new AwsContext(this.sourceConfig, this.awsCredentialsSupplier);
        this.glueDeserializer = KafkaSecurityConfigurer.getGlueSerializer(this.sourceConfig, awsContext);
        if (Objects.nonNull(this.glueDeserializer)) {
            return new KafkaConsumer(consumerProperties, (Deserializer)this.stringDeserializer, (Deserializer)this.glueDeserializer);
        }
        return new KafkaConsumer(consumerProperties);
    }

    public void stop() {
        try {
            KafkaSource.setMdc();
            this.shutdownInProgress.set(true);
            long shutdownWaitTime = this.calculateLongestThreadWaitingTime();
            LOG.info("Shutting down {} Executor services", (Object)this.allTopicExecutorServices.size());
            this.allTopicExecutorServices.forEach(executor -> this.stopExecutor((ExecutorService)executor, shutdownWaitTime));
            LOG.info("Closing {} consumers", (Object)this.allTopicConsumers.size());
            this.allTopicConsumers.forEach(consumer -> consumer.closeConsumer());
            LOG.info("Kafka source shutdown successfully...");
        }
        finally {
            KafkaSource.removeMdc();
        }
    }

    private void stopExecutor(ExecutorService executorService, long shutdownWaitTime) {
        block3: {
            executorService.shutdown();
            try {
                if (!executorService.awaitTermination(shutdownWaitTime, TimeUnit.SECONDS)) {
                    LOG.info("Consumer threads are waiting for shutting down...");
                    executorService.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                if (!(e.getCause() instanceof InterruptedException)) break block3;
                LOG.error("Interrupted during consumer shutdown, exiting uncleanly...", (Throwable)e);
                executorService.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    private long calculateLongestThreadWaitingTime() {
        List<? extends TopicConsumerConfig> topicsList = this.sourceConfig.getTopics();
        return topicsList.stream().map(topics -> topics.getThreadWaitingTime().toSeconds()).max(Comparator.comparingLong(time -> time)).orElse(1L);
    }

    KafkaConsumer getConsumer() {
        return this.kafkaConsumer;
    }

    private Properties getConsumerProperties(TopicConsumerConfig topicConfig, Properties authProperties) {
        Properties properties = (Properties)authProperties.clone();
        if (StringUtils.isNotEmpty((CharSequence)this.sourceConfig.getClientDnsLookup())) {
            ClientDNSLookupType dnsLookupType = ClientDNSLookupType.getDnsLookupType(this.sourceConfig.getClientDnsLookup());
            switch (dnsLookupType) {
                case USE_ALL_DNS_IPS: {
                    properties.put("client.dns.lookup", ClientDNSLookupType.USE_ALL_DNS_IPS.toString());
                    break;
                }
                case CANONICAL_BOOTSTRAP: {
                    properties.put("client.dns.lookup", ClientDNSLookupType.CANONICAL_BOOTSTRAP.toString());
                    break;
                }
                case DEFAULT: {
                    properties.put("client.dns.lookup", ClientDNSLookupType.DEFAULT.toString());
                }
            }
        }
        this.setConsumerTopicProperties(properties, topicConfig);
        this.setSchemaRegistryProperties(properties, topicConfig);
        LOG.debug(DataPrepperMarkers.SENSITIVE, "Starting consumer with the properties : {}", (Object)properties);
        return properties;
    }

    private String getSchemaRegistryUrl() {
        return this.sourceConfig.getSchemaConfig().getRegistryURL();
    }

    private void setSchemaRegistryProperties(Properties properties, TopicConfig topicConfig) {
        SchemaConfig schemaConfig = this.sourceConfig.getSchemaConfig();
        if (Objects.isNull(schemaConfig)) {
            this.setPropertiesForPlaintextAndJsonWithoutSchemaRegistry(properties, topicConfig);
            return;
        }
        if (schemaConfig.getType() == SchemaRegistryType.AWS_GLUE) {
            return;
        }
        if (!StringUtils.isNotEmpty((CharSequence)schemaConfig.getRegistryURL())) {
            throw new RuntimeException("RegistryURL must be specified for confluent schema registry");
        }
        this.setPropertiesForSchemaRegistryConnectivity(properties);
        this.setPropertiesForSchemaType(properties, topicConfig);
    }

    private void setPropertiesForPlaintextAndJsonWithoutSchemaRegistry(Properties properties, TopicConfig topicConfig) {
        MessageFormat dataFormat = topicConfig.getSerdeFormat();
        this.schemaType = dataFormat.toString();
        properties.put("key.deserializer", StringDeserializer.class);
        switch (dataFormat) {
            case JSON: {
                properties.put("value.deserializer", JsonDeserializer.class);
                break;
            }
            default: {
                properties.put("value.deserializer", StringDeserializer.class);
            }
        }
    }

    private void setPropertiesForSchemaType(Properties properties, TopicConfig topic) {
        Properties prop;
        Properties propertyMap = prop = properties;
        properties.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        properties.put("schema.registry.url", this.getSchemaRegistryUrl());
        properties.put("auto.register.schemas", (Object)false);
        schemaRegistryClient = new CachedSchemaRegistryClient(this.getSchemaRegistryUrl(), 100, (Map)propertyMap);
        SchemaConfig schemaConfig = this.sourceConfig.getSchemaConfig();
        try {
            String subject = topic.getName() + "-value";
            this.schemaType = schemaConfig.getVersion() != null ? schemaRegistryClient.getSchemaMetadata(subject, schemaConfig.getVersion().intValue()).getSchemaType() : schemaRegistryClient.getLatestSchemaMetadata(subject).getSchemaType();
        }
        catch (RestClientException | IOException e) {
            LOG.error("Failed to connect to the schema registry...");
            throw new RuntimeException(e);
        }
        if (this.schemaType.equalsIgnoreCase(MessageFormat.JSON.toString())) {
            properties.put("value.deserializer", KafkaJsonSchemaDeserializer.class);
            properties.put("json.value.type", "com.fasterxml.jackson.databind.JsonNode");
        } else if (this.schemaType.equalsIgnoreCase(MessageFormat.AVRO.toString())) {
            properties.put("value.deserializer", KafkaAvroDeserializer.class);
        } else {
            properties.put("value.deserializer", StringDeserializer.class);
        }
    }

    private void setConsumerTopicProperties(Properties properties, TopicConsumerConfig topicConfig) {
        KafkaCustomConsumerFactory.setConsumerTopicProperties(properties, topicConfig, this.consumerGroupID);
    }

    private void setPropertiesForSchemaRegistryConnectivity(Properties properties) {
        AuthConfig authConfig = this.sourceConfig.getAuthConfig();
        String schemaRegistryApiKey = this.sourceConfig.getSchemaConfig().getSchemaRegistryApiKey();
        String schemaRegistryApiSecret = this.sourceConfig.getSchemaConfig().getSchemaRegistryApiSecret();
        if ("USER_INFO".equalsIgnoreCase(this.sourceConfig.getSchemaConfig().getBasicAuthCredentialsSource()) && authConfig.getSaslAuthConfig().getPlainTextAuthConfig() != null) {
            String schemaBasicAuthUserInfo = schemaRegistryApiKey.concat(":").concat(schemaRegistryApiSecret);
            properties.put("basic.auth.user.info", schemaBasicAuthUserInfo);
            properties.put("basic.auth.credentials.source", "USER_INFO");
        }
        if (authConfig != null && authConfig.getSaslAuthConfig() != null) {
            PlainTextAuthConfig plainTextAuthConfig = authConfig.getSaslAuthConfig().getPlainTextAuthConfig();
            OAuthConfig oAuthConfig = authConfig.getSaslAuthConfig().getOAuthConfig();
            if (oAuthConfig != null) {
                properties.put("sasl.mechanism", oAuthConfig.getOauthSaslMechanism());
                properties.put("security.protocol", oAuthConfig.getOauthSecurityProtocol());
            }
        }
    }

    void sleep(long millis) throws InterruptedException {
        Thread.sleep(millis);
    }

    private void updateConfig(KafkaClusterConfigSupplier kafkaClusterConfigSupplier) {
        if (kafkaClusterConfigSupplier != null) {
            if (this.sourceConfig.getBootstrapServers() == null) {
                this.sourceConfig.setBootStrapServers(kafkaClusterConfigSupplier.getBootStrapServers());
            }
            if (this.sourceConfig.getAuthConfig() == null) {
                this.sourceConfig.setAuthConfig(kafkaClusterConfigSupplier.getAuthConfig());
            }
            if (this.sourceConfig.getAwsConfig() == null) {
                this.sourceConfig.setAwsConfig(kafkaClusterConfigSupplier.getAwsConfig());
            }
            if (this.sourceConfig.getEncryptionConfigRaw() == null) {
                this.sourceConfig.setEncryptionConfig(kafkaClusterConfigSupplier.getEncryptionConfig());
            }
        }
    }

    private static void setMdc() {
        MDC.put((String)"kafkaPluginType", (String)MDC_KAFKA_PLUGIN_VALUE);
    }

    private static void removeMdc() {
        MDC.remove((String)"kafkaPluginType");
    }
}

