/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.sink;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.plugins.kafka.configuration.AuthConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.AwsConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.EncryptionConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.KafkaProducerConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.KafkaProducerProperties;
import org.opensearch.dataprepper.plugins.kafka.configuration.SchemaConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.TopicProducerConfig;
import org.opensearch.dataprepper.plugins.kafka.sink.SinkTopicConfig;

public class KafkaSinkConfig
implements KafkaProducerConfig {
    public static final String DLQ = "dlq";
    @JsonProperty(value="bootstrap_servers")
    @NotNull
    @Size(min=1, message="Bootstrap servers can't be empty")
    private @NotNull @Size(min=1, message="Bootstrap servers can't be empty") List<String> bootStrapServers;
    private PluginModel dlq;
    @JsonProperty(value="thread_wait_time")
    private Long threadWaitTime;
    @JsonProperty(value="topic")
    SinkTopicConfig topic;
    @JsonProperty(value="authentication")
    private AuthConfig authConfig;
    @JsonProperty(value="schema")
    @Valid
    private SchemaConfig schemaConfig;
    @JsonProperty(value="serde_format")
    private String serdeFormat;
    @JsonProperty(value="encryption")
    private EncryptionConfig encryptionConfig;
    @JsonProperty(value="aws")
    @Valid
    private AwsConfig awsConfig;
    @JsonProperty(value="partition_key")
    @NotNull
    @NotEmpty
    private String partitionKey;
    @JsonProperty(value="producer_properties")
    private KafkaProducerProperties kafkaProducerProperties;

    @Override
    public Optional<PluginModel> getDlq() {
        return Optional.ofNullable(this.dlq);
    }

    @Override
    public void setDlqConfig(PluginSetting pluginSetting) {
        LinkedHashMap dlq = (LinkedHashMap)pluginSetting.getAttributeFromSettings(DLQ);
        if (dlq != null) {
            if (dlq.size() != 1) {
                throw new RuntimeException("dlq option must declare exactly one dlq configuration");
            }
            Map.Entry entry = (Map.Entry)dlq.entrySet().stream().findFirst().get();
            this.dlq = new PluginModel((String)entry.getKey(), (Map)entry.getValue());
        }
    }

    @Override
    public SchemaConfig getSchemaConfig() {
        return this.schemaConfig;
    }

    @Override
    public AuthConfig getAuthConfig() {
        return this.authConfig;
    }

    @Override
    public EncryptionConfig getEncryptionConfig() {
        if (Objects.isNull(this.encryptionConfig)) {
            return new EncryptionConfig();
        }
        return this.encryptionConfig;
    }

    @Override
    public AwsConfig getAwsConfig() {
        return this.awsConfig;
    }

    public List<String> getBootstrapServers() {
        return this.bootStrapServers;
    }

    @Override
    public String getSerdeFormat() {
        if (ObjectUtils.isEmpty((Object)this.serdeFormat)) {
            this.serdeFormat = "plaintext";
        }
        return this.serdeFormat;
    }

    public Long getThreadWaitTime() {
        return this.threadWaitTime;
    }

    public void setBootStrapServers(List<String> bootStrapServers) {
        this.bootStrapServers = bootStrapServers;
    }

    public void setThreadWaitTime(Long threadWaitTime) {
        this.threadWaitTime = threadWaitTime;
    }

    public void setAuthConfig(AuthConfig authConfig) {
        this.authConfig = authConfig;
    }

    public void setSchemaConfig(SchemaConfig schemaConfig) {
        this.schemaConfig = schemaConfig;
    }

    @Override
    public TopicProducerConfig getTopic() {
        return this.topic;
    }

    public void setTopic(SinkTopicConfig topic) {
        this.topic = topic;
    }

    @Override
    public KafkaProducerProperties getKafkaProducerProperties() {
        return this.kafkaProducerProperties;
    }

    @Override
    public String getPartitionKey() {
        return this.partitionKey;
    }
}

