/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.configuration;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum EncryptionType {
    NONE("none"),
    SSL("ssl");

    private static final Map<String, EncryptionType> OPTIONS_MAP;
    private final String type;

    private EncryptionType(String type) {
        this.type = type;
    }

    @JsonCreator
    static EncryptionType fromTypeValue(String type) {
        return OPTIONS_MAP.get(type.toLowerCase());
    }

    static {
        OPTIONS_MAP = Arrays.stream(EncryptionType.values()).collect(Collectors.toMap(value -> value.type, value -> value));
    }
}

