/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.authenticator;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.kafka.common.security.authenticator.SaslClientCallbackHandler;
import org.opensearch.dataprepper.plugins.kafka.authenticator.BasicCredentials;
import org.opensearch.dataprepper.plugins.kafka.authenticator.DynamicBasicCredentialsProvider;

public class DynamicSaslClientCallbackHandler
extends SaslClientCallbackHandler {
    private final DynamicBasicCredentialsProvider dynamicBasicCredentialsProvider = DynamicBasicCredentialsProvider.getInstance();

    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        super.handle(callbacks);
        BasicCredentials basicCredentials = this.dynamicBasicCredentialsProvider.getBasicCredentials();
        for (Callback callback : callbacks) {
            Callback nc;
            if (callback instanceof NameCallback) {
                nc = (NameCallback)callback;
                if (basicCredentials.getUsername() != null) {
                    ((NameCallback)nc).setName(basicCredentials.getUsername());
                    continue;
                }
                ((NameCallback)nc).setName(((NameCallback)nc).getDefaultName());
                continue;
            }
            if (!(callback instanceof PasswordCallback)) continue;
            nc = (PasswordCallback)callback;
            if (basicCredentials.getPassword() == null) {
                String errorMessage = "Could not login: the client is being asked for a password.";
                throw new UnsupportedCallbackException(callback, errorMessage);
            }
            char[] password = basicCredentials.getPassword().toCharArray();
            ((PasswordCallback)nc).setPassword(password);
        }
    }
}

