/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.admin;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.opensearch.dataprepper.plugins.kafka.consumer.TopicEmptinessMetadata;
import org.opensearch.dataprepper.plugins.kafka.util.KafkaClusterAuthConfig;
import org.opensearch.dataprepper.plugins.kafka.util.KafkaSecurityConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaAdminAccessor {
    static final Logger LOG = LoggerFactory.getLogger(KafkaAdminAccessor.class);
    private final AdminClient kafkaAdminClient;
    private final TopicEmptinessMetadata topicEmptinessMetadata;
    private final List<String> consumerGroupIds;

    public KafkaAdminAccessor(KafkaClusterAuthConfig kafkaClusterAuthConfig, List<String> consumerGroupIds) {
        Properties authProperties = new Properties();
        KafkaSecurityConfigurer.setAuthProperties(authProperties, kafkaClusterAuthConfig, LOG);
        this.kafkaAdminClient = KafkaAdminClient.create((Properties)authProperties);
        this.topicEmptinessMetadata = new TopicEmptinessMetadata();
        this.consumerGroupIds = consumerGroupIds;
    }

    @VisibleForTesting
    KafkaAdminAccessor(AdminClient kafkaAdminClient, TopicEmptinessMetadata topicEmptinessMetadata, List<String> consumerGroupIds) {
        this.kafkaAdminClient = kafkaAdminClient;
        this.topicEmptinessMetadata = topicEmptinessMetadata;
        this.consumerGroupIds = consumerGroupIds;
    }

    public synchronized boolean areTopicsEmpty() {
        Map endOffsets;
        long currentThreadId = Thread.currentThread().getId();
        if (Objects.isNull(this.topicEmptinessMetadata.getTopicEmptyCheckingOwnerThreadId())) {
            this.topicEmptinessMetadata.setTopicEmptyCheckingOwnerThreadId(currentThreadId);
        }
        if (currentThreadId != this.topicEmptinessMetadata.getTopicEmptyCheckingOwnerThreadId() || this.topicEmptinessMetadata.isWithinCheckInterval(System.currentTimeMillis())) {
            return this.topicEmptinessMetadata.isTopicEmpty();
        }
        HashMap committedOffsets = new HashMap();
        for (String consumerGroupId : this.consumerGroupIds) {
            ListConsumerGroupOffsetsResult listConsumerGroupOffsets = this.kafkaAdminClient.listConsumerGroupOffsets(consumerGroupId);
            try {
                committedOffsets.putAll((Map)listConsumerGroupOffsets.partitionsToOffsetAndMetadata().get());
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error("Caught exception getting committed offset data", (Throwable)e);
                return false;
            }
        }
        Map<TopicPartition, OffsetSpec> listOffsetsRequest = committedOffsets.keySet().stream().collect(Collectors.toMap(topicPartition -> topicPartition, topicPartition -> OffsetSpec.latest()));
        try {
            endOffsets = (Map)this.kafkaAdminClient.listOffsets(listOffsetsRequest).all().get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Caught exception getting end offset data", (Throwable)e);
            return false;
        }
        for (TopicPartition topicPartition2 : committedOffsets.keySet()) {
            OffsetAndMetadata offsetAndMetadata = (OffsetAndMetadata)committedOffsets.get(topicPartition2);
            if (!endOffsets.containsKey(topicPartition2)) {
                LOG.warn("No end offset found for topic partition: {}", (Object)topicPartition2);
                return false;
            }
            long endOffset = ((ListOffsetsResult.ListOffsetsResultInfo)endOffsets.get(topicPartition2)).offset();
            this.topicEmptinessMetadata.updateTopicEmptinessStatus(topicPartition2, true);
            if (endOffset == 0L || !Objects.isNull(offsetAndMetadata) && offsetAndMetadata.offset() >= endOffset) continue;
            this.topicEmptinessMetadata.updateTopicEmptinessStatus(topicPartition2, false);
        }
        this.topicEmptinessMetadata.setLastIsEmptyCheckTime(System.currentTimeMillis());
        return this.topicEmptinessMetadata.isTopicEmpty();
    }
}

