/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.stream;

import com.github.shyiko.mysql.binlog.BinaryLogClient;
import java.util.Optional;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourceCoordinator;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourcePartition;
import org.opensearch.dataprepper.plugins.source.rds.coordination.partition.StreamPartition;
import org.opensearch.dataprepper.plugins.source.rds.model.BinlogCoordinate;
import org.opensearch.dataprepper.plugins.source.rds.stream.BinlogClientWrapper;
import org.opensearch.dataprepper.plugins.source.rds.stream.LogicalReplicationClient;
import org.opensearch.dataprepper.plugins.source.rds.stream.ReplicationLogClient;
import org.opensearch.dataprepper.plugins.source.rds.utils.ServerIdGenerator;
import org.postgresql.replication.LogSequenceNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamWorker {
    private static final Logger LOG = LoggerFactory.getLogger(StreamWorker.class);
    private static final int DEFAULT_EXPORT_COMPLETE_WAIT_INTERVAL_MILLIS = 60000;
    private final EnhancedSourceCoordinator sourceCoordinator;
    private final ReplicationLogClient replicationLogClient;
    private final PluginMetrics pluginMetrics;

    StreamWorker(EnhancedSourceCoordinator sourceCoordinator, ReplicationLogClient replicationLogClient, PluginMetrics pluginMetrics) {
        this.sourceCoordinator = sourceCoordinator;
        this.replicationLogClient = replicationLogClient;
        this.pluginMetrics = pluginMetrics;
    }

    public static StreamWorker create(EnhancedSourceCoordinator sourceCoordinator, ReplicationLogClient replicationLogClient, PluginMetrics pluginMetrics) {
        return new StreamWorker(sourceCoordinator, replicationLogClient, pluginMetrics);
    }

    public void processStream(StreamPartition streamPartition) {
        while (this.shouldWaitForExport(streamPartition) && !Thread.currentThread().isInterrupted()) {
            LOG.info("Initial load not completed yet for {}, waiting...", (Object)streamPartition.getPartitionKey());
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException ex) {
                LOG.info("The Stream Scheduler was interrupted while waiting to retry, stopping processing");
                Thread.currentThread().interrupt();
                break;
            }
        }
        if (this.replicationLogClient instanceof BinlogClientWrapper) {
            this.setStartBinlogPosition(streamPartition);
            this.setServerId();
        } else {
            this.setStartLsn(streamPartition);
        }
        try {
            LOG.info("Connect to database to read change events.");
            this.replicationLogClient.connect();
        }
        catch (Exception e) {
            LOG.warn("Error while connecting to replication stream, will retry.");
            LOG.debug("Give up stream partition and shut down stream worker");
            this.sourceCoordinator.giveUpPartition((EnhancedSourcePartition)streamPartition);
            this.shutdown();
            throw new RuntimeException(e);
        }
        LOG.debug("Exited connect() method in stream worker.");
    }

    public void shutdown() {
        try {
            this.replicationLogClient.disconnect();
        }
        catch (Exception e) {
            LOG.error("Replication log client failed to disconnect.", (Throwable)e);
        }
    }

    private boolean shouldWaitForExport(StreamPartition streamPartition) {
        if (!streamPartition.getProgressState().get().shouldWaitForExport()) {
            LOG.debug("Export is not enabled. Proceed with streaming.");
            return false;
        }
        return !this.isExportDone(streamPartition);
    }

    private boolean isExportDone(StreamPartition streamPartition) {
        String dbIdentifier = streamPartition.getPartitionKey();
        Optional globalStatePartition = this.sourceCoordinator.getPartition("stream-for-" + dbIdentifier);
        return globalStatePartition.isPresent();
    }

    private void setStartBinlogPosition(StreamPartition streamPartition) {
        BinlogCoordinate startBinlogPosition = streamPartition.getProgressState().get().getMySqlStreamState().getCurrentPosition();
        if (startBinlogPosition != null) {
            String binlogFilename = startBinlogPosition.getBinlogFilename();
            long binlogPosition = startBinlogPosition.getBinlogPosition();
            LOG.debug("Will start binlog stream from binlog file {} and position {}.", (Object)binlogFilename, (Object)binlogPosition);
            BinaryLogClient binaryLogClient = ((BinlogClientWrapper)this.replicationLogClient).getBinlogClient();
            binaryLogClient.setBinlogFilename(binlogFilename);
            binaryLogClient.setBinlogPosition(binlogPosition);
        }
    }

    private void setServerId() {
        int serverId = ServerIdGenerator.generateServerId();
        LOG.info("Binary log client server id is {}", (Object)serverId);
        ((BinlogClientWrapper)this.replicationLogClient).getBinlogClient().setServerId((long)serverId);
    }

    private void setStartLsn(StreamPartition streamPartition) {
        String startLsn = streamPartition.getProgressState().get().getPostgresStreamState().getCurrentLsn();
        if (startLsn != null) {
            LOG.debug("Will start logical replication from LSN {}", (Object)startLsn);
            LogicalReplicationClient logicalReplicationClient = (LogicalReplicationClient)this.replicationLogClient;
            logicalReplicationClient.setStartLsn(LogSequenceNumber.valueOf((String)startLsn));
        }
    }
}

